<?php
/**
 * Pro Upgrade page for ShopWriter Lite
 *
 * @since      1.0.0
 * @package    ShopWriter_Lite
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Determine which feature was requested.
// Ignore CSRF for GET parameter since this is not modifying data.
// phpcs:disable WordPress.Security.NonceVerification.Recommended
$shopwr_lite_page                = isset( $_GET['page'] ) ? sanitize_text_field( wp_unslash( $_GET['page'] ) ) : '';
$shopwr_lite_feature_name        = '';
$shopwr_lite_feature_description = '';

switch ( $shopwr_lite_page ) {
	case 'shopwr-lite-category-generator-pro':
		$shopwr_lite_feature_name        = __( 'Category Generator', 'shopwriter-lite' );
		$shopwr_lite_feature_description = __( 'Generate AI-powered descriptions for your WooCommerce product categories. Save time and improve SEO with unique, compelling category descriptions.', 'shopwriter-lite' );
		break;
	case 'shopwr-lite-redirects-pro':
		$shopwr_lite_feature_name        = __( '301 Redirects', 'shopwriter-lite' );
		$shopwr_lite_feature_description = __( 'Automatically create 301 redirects when product URLs change. Preserve your SEO rankings and ensure customers always find the right products.', 'shopwriter-lite' );
		break;
	case 'shopwr-lite-queue-pro':
		$shopwr_lite_feature_name        = __( 'Queue Processing', 'shopwriter-lite' );
		$shopwr_lite_feature_description = __( 'Process large batches of products in the background. Queue management ensures reliable content generation even for thousands of products.', 'shopwriter-lite' );
		break;
	default:
		$shopwr_lite_feature_name        = __( 'Pro Feature', 'shopwriter-lite' );
		$shopwr_lite_feature_description = __( 'This feature is available in ShopWriter Pro.', 'shopwriter-lite' );
}
?>

<div class="wrap shopwr-lite-pro-upgrade-page">
	<div class="shopwr-lite-pro-upgrade-container">
		<div class="upgrade-header">
			<div class="lock-icon">
				<svg width="64" height="64" viewBox="0 0 24 24" fill="currentColor">
					<path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/>
				</svg>
			</div>
			<h1><?php echo esc_html( $shopwr_lite_feature_name ); ?></h1>
			<span class="pro-badge">PRO</span>
		</div>

		<div class="upgrade-content">
			<p class="feature-description"><?php echo esc_html( $shopwr_lite_feature_description ); ?></p>

			<div class="feature-benefits">
				<h3><?php esc_html_e( 'Upgrade to Pro and get:', 'shopwriter-lite' ); ?></h3>
				<ul>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'Product Title Generation', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'FAQ Section Generation', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'Category Description Generator', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'Automatic 301 Redirects', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'Background Queue Processing', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'Custom AI Instructions', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'Content Length Settings', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'Open Graph Meta Tags', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'All Gallery Images Alt Text', 'shopwriter-lite' ); ?>
					</li>
					<li>
						<span class="dashicons dashicons-yes"></span>
						<?php esc_html_e( 'Priority Support', 'shopwriter-lite' ); ?>
					</li>
				</ul>
			</div>

			<div class="upgrade-cta">
				<a href="https://shop-writer.com/pricing/?utm_source=plugin&utm_medium=pro_page&utm_campaign=lite&feature=<?php echo esc_attr( sanitize_title( $feature_name ) ); ?>" target="_blank" class="button button-primary button-hero">
					<?php esc_html_e( 'Upgrade to Pro Now', 'shopwriter-lite' ); ?>
				</a>
				<p class="money-back">
					<?php esc_html_e( '30-day money-back guarantee', 'shopwriter-lite' ); ?>
				</p>
			</div>
		</div>

		<div class="upgrade-footer">
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=shopwriter-lite' ) ); ?>">
				&larr; <?php esc_html_e( 'Back to Dashboard', 'shopwriter-lite' ); ?>
			</a>
		</div>
	</div>
</div>
