<?php
/**
 * Bulk Content Generator page for ShopWriter Lite
 *
 * @since      1.0.0
 * @package    ShopWriter_Lite
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get product categories.
$shopwr_lite_categories = get_terms(
	array(
		'taxonomy'   => 'product_cat',
		'hide_empty' => false,
	)
);

// Get product attributes.
$shopwr_lite_attributes = wc_get_attribute_taxonomies();

// Get settings.
$shopwr_lite_settings = $this->api->get_settings();

// Check if API key is set.
$shopwr_lite_has_api_key = ! empty( $shopwr_lite_settings['api_key'] );
?>

<div class="wrap shopwr-lite-bulk-generator">
	<h1><?php esc_html_e( 'Bulk Content Generator', 'shopwriter-lite' ); ?></h1>

	<?php if ( ! $shopwr_lite_has_api_key ) : ?>
		<div class="notice notice-warning">
			<p>
				<?php
				printf(
					/* translators: %s: link to settings */
					esc_html__( 'Please add your API key in the %s to start generating content.', 'shopwriter-lite' ),
					'<a href="' . esc_url( admin_url( 'admin.php?page=shopwriter-lite-settings' ) ) . '">' . esc_html__( 'Settings', 'shopwriter-lite' ) . '</a>'
				);
				?>
			</p>
		</div>
	<?php endif; ?>

	<!-- Lite Version Notice -->
	<div class="shopwr-lite-notice shopwr-lite-notice-info">
		<p>
			<strong><?php esc_html_e( 'Lite Version:', 'shopwriter-lite' ); ?></strong>
			<?php esc_html_e( 'You can generate Short Description, Product Description, Meta Title, Meta Description, and Featured Image Alt Text.', 'shopwriter-lite' ); ?>
			<a href="https://shop-writer.com/pricing/?utm_source=plugin&utm_medium=bulk&utm_campaign=lite" target="_blank">
				<?php esc_html_e( 'Upgrade to Pro for more features', 'shopwriter-lite' ); ?>
			</a>
		</p>
	</div>

	<div class="shopwr-lite-bulk-container">
		<!-- Step 1: Filter Products -->
		<div class="shopwr-lite-bulk-step" id="step-filter">
			<h2><?php esc_html_e( 'Step 1: Select Products', 'shopwriter-lite' ); ?></h2>

			<div class="shopwr-lite-filter-section">
				<h3><?php esc_html_e( 'Filter by Category', 'shopwriter-lite' ); ?></h3>
				<div class="shopwr-lite-categories-list">
					<?php if ( ! empty( $shopwr_lite_categories ) && ! is_wp_error( $shopwr_lite_categories ) ) : ?>
						<?php foreach ( $shopwr_lite_categories as $shopwr_lite_category ) : ?>
							<label class="shopwr-lite-checkbox-label">
								<input type="checkbox" name="categories[]" value="<?php echo esc_attr( $shopwr_lite_category->term_id ); ?>">
								<?php echo esc_html( $shopwr_lite_category->name ); ?> (<?php echo esc_html( $shopwr_lite_category->count ); ?>)
							</label>
						<?php endforeach; ?>
					<?php else : ?>
						<p><?php esc_html_e( 'No categories found.', 'shopwriter-lite' ); ?></p>
					<?php endif; ?>
				</div>
			</div>

			<?php if ( ! empty( $shopwr_lite_attributes ) ) : ?>
			<div class="shopwr-lite-filter-section">
				<h3><?php esc_html_e( 'Filter by Attributes', 'shopwriter-lite' ); ?></h3>
				<?php foreach ( $shopwr_lite_attributes as $shopwr_lite_attribute ) : ?>
					<?php
					$shopwr_lite_terms = get_terms(
						array(
							'taxonomy'   => 'pa_' . $shopwr_lite_attribute->attribute_name,
							'hide_empty' => false,
						)
					);
					if ( ! empty( $shopwr_lite_terms ) && ! is_wp_error( $shopwr_lite_terms ) ) :
						?>
						<div class="shopwr-lite-attribute-group">
							<h4><?php echo esc_html( $shopwr_lite_attribute->attribute_label ); ?></h4>
							<div class="shopwr-lite-attribute-terms">
								<?php foreach ( $shopwr_lite_terms as $shopwr_lite_term ) : ?>
									<label class="shopwr-lite-checkbox-label">
										<input type="checkbox" name="attributes[pa_<?php echo esc_attr( $shopwr_lite_term->attribute_name ); ?>][]" value="<?php echo esc_attr( $term->term_id ); ?>">
										<?php echo esc_html( $shopwr_lite_term->name ); ?>
									</label>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif; ?>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>

			<div class="shopwr-lite-filter-actions">
				<button type="button" class="button" id="select-all-categories"><?php esc_html_e( 'Select All', 'shopwriter-lite' ); ?></button>
				<button type="button" class="button" id="deselect-all-categories"><?php esc_html_e( 'Deselect All', 'shopwriter-lite' ); ?></button>
			</div>
		</div>

		<!-- Step 2: Select Fields -->
		<div class="shopwr-lite-bulk-step" id="step-fields">
			<h2><?php esc_html_e( 'Step 2: Select Fields to Generate', 'shopwriter-lite' ); ?></h2>

			<div class="shopwr-lite-fields-list">
				<!-- Lite Fields (Available) -->
				<label class="shopwr-lite-checkbox-label shopwr-lite-field-available">
					<input type="checkbox" name="fields[]" value="short_description" checked>
					<?php esc_html_e( 'Short Description', 'shopwriter-lite' ); ?>
				</label>

				<label class="shopwr-lite-checkbox-label shopwr-lite-field-available">
					<input type="checkbox" name="fields[]" value="description" checked>
					<?php esc_html_e( 'Product Description', 'shopwriter-lite' ); ?>
				</label>

				<label class="shopwr-lite-checkbox-label shopwr-lite-field-available">
					<input type="checkbox" name="fields[]" value="meta_title" checked>
					<?php esc_html_e( 'Meta Title', 'shopwriter-lite' ); ?>
				</label>

				<label class="shopwr-lite-checkbox-label shopwr-lite-field-available">
					<input type="checkbox" name="fields[]" value="meta_description" checked>
					<?php esc_html_e( 'Meta Description', 'shopwriter-lite' ); ?>
				</label>

				<label class="shopwr-lite-checkbox-label shopwr-lite-field-available">
					<input type="checkbox" name="fields[]" value="alt_text" checked>
					<?php esc_html_e( 'Featured Image Alt Text', 'shopwriter-lite' ); ?>
				</label>

				<!-- PRO Fields (Disabled) -->
				<label class="shopwr-lite-checkbox-label shopwr-lite-field-pro disabled">
					<input type="checkbox" disabled>
					<?php esc_html_e( 'Product Title', 'shopwriter-lite' ); ?>
					<span class="shopwr-lite-pro-badge">
						<svg width="10" height="10" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
						PRO
					</span>
				</label>

				<label class="shopwr-lite-checkbox-label shopwr-lite-field-pro disabled">
					<input type="checkbox" disabled>
					<?php esc_html_e( 'FAQ Section', 'shopwriter-lite' ); ?>
					<span class="shopwr-lite-pro-badge">
						<svg width="10" height="10" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
						PRO
					</span>
				</label>

				<label class="shopwr-lite-checkbox-label shopwr-lite-field-pro disabled">
					<input type="checkbox" disabled>
					<?php esc_html_e( 'All Images Alt Text', 'shopwriter-lite' ); ?>
					<span class="shopwr-lite-pro-badge">
						<svg width="10" height="10" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
						PRO
					</span>
				</label>
			</div>
		</div>

		<!-- Step 3: Operation -->
		<div class="shopwr-lite-bulk-step" id="step-operation">
			<h2><?php esc_html_e( 'Step 3: Choose Operation', 'shopwriter-lite' ); ?></h2>

			<div class="shopwr-lite-operation-options">
				<label class="shopwr-lite-radio-label">
					<input type="radio" name="operation" value="generate" checked>
					<strong><?php esc_html_e( 'Generate', 'shopwriter-lite' ); ?></strong>
					<span><?php esc_html_e( 'Create new content for products', 'shopwriter-lite' ); ?></span>
				</label>

				<label class="shopwr-lite-radio-label">
					<input type="radio" name="operation" value="rewrite">
					<strong><?php esc_html_e( 'Rewrite', 'shopwriter-lite' ); ?></strong>
					<span><?php esc_html_e( 'Rewrite existing content to avoid duplicates', 'shopwriter-lite' ); ?></span>
				</label>
			</div>
		</div>

		<!-- Actions -->
		<div class="shopwr-lite-bulk-actions">
			<button type="button" class="button button-primary button-hero" id="start-bulk-preview" <?php echo ! $has_api_key ? 'disabled' : ''; ?>>
				<?php esc_html_e( 'Preview Products', 'shopwriter-lite' ); ?>
			</button>
		</div>

		<!-- Progress Section (Hidden initially) -->
		<div class="shopwr-lite-bulk-progress" id="bulk-progress" style="display: none;">
			<h2><?php esc_html_e( 'Generating Content...', 'shopwriter-lite' ); ?></h2>
			<div class="shopwr-lite-progress-bar">
				<div class="shopwr-lite-progress-fill" style="width: 0%;"></div>
			</div>
			<div class="shopwr-lite-progress-stats">
				<span class="processed">0</span> / <span class="total">0</span> <?php esc_html_e( 'products processed', 'shopwriter-lite' ); ?>
			</div>
			<div class="shopwr-lite-progress-current">
				<span class="current-product"></span>
			</div>
		</div>

		<!-- Results Section (Hidden initially) -->
		<div class="shopwr-lite-bulk-results" id="bulk-results" style="display: none;">
			<h2><?php esc_html_e( 'Generation Complete', 'shopwriter-lite' ); ?></h2>
			<div class="shopwr-lite-results-summary">
				<div class="result-item success">
					<span class="count">0</span>
					<span class="label"><?php esc_html_e( 'Successful', 'shopwriter-lite' ); ?></span>
				</div>
				<div class="result-item failed">
					<span class="count">0</span>
					<span class="label"><?php esc_html_e( 'Failed', 'shopwriter-lite' ); ?></span>
				</div>
			</div>
			<button type="button" class="button" id="start-new-batch">
				<?php esc_html_e( 'Start New Batch', 'shopwriter-lite' ); ?>
			</button>
		</div>
	</div>
</div>
