<?php
/**
 * Admin Dashboard for ShopWriter Lite
 *
 * @since      1.0.0
 * @package    ShopWriter_Lite
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$shopwr_lite_settings    = $this->api->get_settings();
$shopwr_lite_has_api_key = ! empty( $shopwr_lite_settings['api_key'] );

// Get basic stats.
$shopwr_lite_total_products     = wp_count_posts( 'product' );
$shopwr_lite_published_products = isset( $shopwr_lite_total_products->publish ) ? $shopwr_lite_total_products->publish : 0;

// Get recent log count.
$shopwr_lite_log            = new SHOPWR_Lite_Log();
$shopwr_lite_recent_updates = $shopwr_lite_log->count_logs();
?>

<div class="wrap shopwr-lite-dashboard">
	<h1><?php esc_html_e( 'ShopWriter Lite', 'shopwriter-lite' ); ?></h1>

	<!-- Welcome Banner -->
	<div class="shopwr-lite-welcome-banner">
		<div class="welcome-content">
			<h2><?php esc_html_e( 'Welcome to ShopWriter Lite!', 'shopwriter-lite' ); ?></h2>
			<p><?php esc_html_e( 'Generate AI-powered product descriptions, meta titles, and more for your WooCommerce store.', 'shopwriter-lite' ); ?></p>

			<?php if ( ! $shopwr_lite_has_api_key ) : ?>
				<div class="shopwr-lite-setup-steps">
					<p><strong><?php esc_html_e( 'Get started in 2 easy steps:', 'shopwriter-lite' ); ?></strong></p>
					<ol>
						<li>
							<a href="https://shop-writer.com/my-account/?utm_source=plugin&utm_medium=dashboard&utm_campaign=lite" target="_blank">
								<?php esc_html_e( 'Get your API key', 'shopwriter-lite' ); ?>
							</a>
						</li>
						<li>
							<a href="<?php echo esc_url( admin_url( 'admin.php?page=shopwriter-lite-settings' ) ); ?>">
								<?php esc_html_e( 'Add your API key in Settings', 'shopwriter-lite' ); ?>
							</a>
						</li>
					</ol>
				</div>
			<?php else : ?>
				<p class="shopwr-lite-api-status success">
					<span class="dashicons dashicons-yes-alt"></span>
					<?php esc_html_e( 'API key configured! You\'re ready to generate content.', 'shopwriter-lite' ); ?>
				</p>
			<?php endif; ?>
		</div>
	</div>

	<!-- Quick Stats -->
	<div class="shopwr-lite-stats-grid">
		<div class="shopwr-lite-stat-card">
			<div class="stat-icon">
				<span class="dashicons dashicons-products"></span>
			</div>
			<div class="stat-content">
				<span class="stat-number"><?php echo esc_html( $shopwr_lite_published_products ); ?></span>
				<span class="stat-label"><?php esc_html_e( 'Products', 'shopwriter-lite' ); ?></span>
			</div>
		</div>

		<div class="shopwr-lite-stat-card">
			<div class="stat-icon">
				<span class="dashicons dashicons-update"></span>
			</div>
			<div class="stat-content">
				<span class="stat-number"><?php echo esc_html( $shopwr_lite_recent_updates ); ?></span>
				<span class="stat-label"><?php esc_html_e( 'Content Updates', 'shopwriter-lite' ); ?></span>
			</div>
		</div>

		<div class="shopwr-lite-stat-card">
			<div class="stat-icon">
				<span class="dashicons dashicons-admin-generic"></span>
			</div>
			<div class="stat-content">
				<span class="stat-number">5</span>
				<span class="stat-label"><?php esc_html_e( 'Available Fields', 'shopwriter-lite' ); ?></span>
			</div>
		</div>
	</div>

	<!-- Quick Actions -->
	<div class="shopwr-lite-quick-actions">
		<h2><?php esc_html_e( 'Quick Actions', 'shopwriter-lite' ); ?></h2>
		<div class="actions-grid">
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=shopwr-lite-bulk-generator' ) ); ?>" class="action-card">
				<span class="dashicons dashicons-admin-page"></span>
				<span class="action-title"><?php esc_html_e( 'Bulk Generator', 'shopwriter-lite' ); ?></span>
				<span class="action-desc"><?php esc_html_e( 'Generate content for multiple products at once', 'shopwriter-lite' ); ?></span>
			</a>

			<a href="<?php echo esc_url( admin_url( 'admin.php?page=shopwr-lite-update-logs' ) ); ?>" class="action-card">
				<span class="dashicons dashicons-backup"></span>
				<span class="action-title"><?php esc_html_e( 'Update Logs', 'shopwriter-lite' ); ?></span>
				<span class="action-desc"><?php esc_html_e( 'View content update history and revert changes', 'shopwriter-lite' ); ?></span>
			</a>

			<a href="<?php echo esc_url( admin_url( 'admin.php?page=shopwriter-lite-settings' ) ); ?>" class="action-card">
				<span class="dashicons dashicons-admin-settings"></span>
				<span class="action-title"><?php esc_html_e( 'Settings', 'shopwriter-lite' ); ?></span>
				<span class="action-desc"><?php esc_html_e( 'Configure API key and generation settings', 'shopwriter-lite' ); ?></span>
			</a>

			<a href="<?php echo esc_url( admin_url( 'edit.php?post_type=product' ) ); ?>" class="action-card">
				<span class="dashicons dashicons-cart"></span>
				<span class="action-title"><?php esc_html_e( 'Products', 'shopwriter-lite' ); ?></span>
				<span class="action-desc"><?php esc_html_e( 'Edit individual products and generate content', 'shopwriter-lite' ); ?></span>
			</a>
		</div>
	</div>

	<!-- Lite vs Pro Comparison -->
	<div class="shopwr-lite-comparison">
		<h2><?php esc_html_e( 'Lite vs Pro Features', 'shopwriter-lite' ); ?></h2>
		<table class="shopwr-lite-comparison-table">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Feature', 'shopwriter-lite' ); ?></th>
					<th><?php esc_html_e( 'Lite', 'shopwriter-lite' ); ?></th>
					<th><?php esc_html_e( 'Pro', 'shopwriter-lite' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td><?php esc_html_e( 'Short Description', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-yes"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Product Description', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-yes"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Meta Title & Description', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-yes"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Featured Image Alt Text', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-yes"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Product Title Generation', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-no-alt"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'FAQ Section', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-no-alt"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Category Generator', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-no-alt"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( '301 Redirects', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-no-alt"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Background Queue Processing', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-no-alt"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Custom AI Instructions', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-no-alt"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Length Validation Settings', 'shopwriter-lite' ); ?></td>
					<td><span class="dashicons dashicons-no-alt"></span></td>
					<td><span class="dashicons dashicons-yes"></span></td>
				</tr>
			</tbody>
		</table>

		<div class="shopwr-lite-upgrade-cta">
			<a href="https://shop-writer.com/pricing/?utm_source=plugin&utm_medium=dashboard&utm_campaign=lite" target="_blank" class="button button-primary button-hero">
				<?php esc_html_e( 'Upgrade to Pro', 'shopwriter-lite' ); ?>
			</a>
		</div>
	</div>

	<!-- Help & Support -->
	<div class="shopwr-lite-help">
		<h2><?php esc_html_e( 'Help & Support', 'shopwriter-lite' ); ?></h2>
		<div class="help-links">
			<a href="https://shop-writer.com/docs/?utm_source=plugin&utm_medium=dashboard&utm_campaign=lite" target="_blank">
				<span class="dashicons dashicons-book"></span>
				<?php esc_html_e( 'Documentation', 'shopwriter-lite' ); ?>
			</a>
			<a href="https://shop-writer.com/support/?utm_source=plugin&utm_medium=dashboard&utm_campaign=lite" target="_blank">
				<span class="dashicons dashicons-sos"></span>
				<?php esc_html_e( 'Support', 'shopwriter-lite' ); ?>
			</a>
			<a href="https://shop-writer.com/faq/?utm_source=plugin&utm_medium=dashboard&utm_campaign=lite" target="_blank">
				<span class="dashicons dashicons-editor-help"></span>
				<?php esc_html_e( 'FAQ', 'shopwriter-lite' ); ?>
			</a>
		</div>
	</div>
</div>
