<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap wcm-admin-page">
    <div class="wcm-header-modern">
        <?php
            $donate_url  = apply_filters('shopc_donate_url', 'https://www.patreon.com/14815994/join');
            $donate_text = apply_filters('shopc_donate_text', 'Buy me a coffee');
        ?>
        <?php if (!empty($donate_url)) : ?>
            <a class="button button-primary wcm-donate-btn" target="_blank" rel="noopener noreferrer" href="<?php echo esc_url($donate_url); ?>" title="<?php echo esc_attr($donate_text); ?>">☕ <?php echo esc_html($donate_text); ?></a>
        <?php endif; ?>
        <h1><?php echo esc_html__( 'ShopCatFlow', 'shopcatflow' ); ?></h1>
        <p><?php echo esc_html__( 'Streamlined drag-and-drop category management for WooCommerce with clear child/sibling previews and auto-save.', 'shopcatflow' ); ?></p>
    </div>

    <div class="wcm-messages"></div>

    

    <?php if (empty($categories)): ?>
        <div class="wcm-no-categories">
            <p><?php echo esc_html__( 'No categories were found or could not be loaded.', 'shopcatflow' ); ?></p>
            <p><a href="<?php echo esc_url(admin_url('edit-tags.php?taxonomy=product_cat&post_type=product')); ?>" class="button button-primary"><?php echo esc_html__( 'Add New Category', 'shopcatflow' ); ?></a></p>
        </div>
    <?php else: ?>
        <div class="wcm-view-toggle">
            <button type="button" class="button button-secondary wcm-toggle-list is-active" data-target="list"><?php echo esc_html__( 'List View', 'shopcatflow' ); ?></button>
            <button type="button" class="button button-secondary wcm-toggle-graph" data-target="graph"><?php echo esc_html__( 'Graph View', 'shopcatflow' ); ?></button>
        </div>

        <div class="wcm-category-container" id="wcm-list-view">
            <div class="wcm-filter" style="margin:8px 0 12px; display:flex; gap:12px; align-items:center; flex-wrap:wrap;">
                <div>
                    <label for="wcm-filter-input" style="font-weight:600;">Filter:</label>
                    <input type="search" id="wcm-filter-input" class="regular-text" placeholder="Type to filter categories" style="max-width:320px; margin-left:6px;">
                </div>
                <div class="wcm-bulk-actions" style="display:flex; gap:8px; align-items:center;">
                    <label><input type="checkbox" id="wcm-select-visible"> Select visible</label>
                    <label><input type="checkbox" id="wcm-delete-children"> Also delete subcategories</label>
                    <button type="button" class="button button-secondary" id="wcm-bulk-delete">Delete selected</button>
                    <span style="flex:1 1 auto"></span>
                    <button type="button" class="button" id="wcm-undo" title="<?php echo esc_attr__( 'Undo (Ctrl/Cmd+Z)', 'shopcatflow' ); ?>">⟲ <?php echo esc_html__( 'Undo', 'shopcatflow' ); ?></button>
                    <button type="button" class="button" id="wcm-redo" title="<?php echo esc_attr__( 'Redo (Ctrl+Y / Ctrl+Shift+Z)', 'shopcatflow' ); ?>">⟳ <?php echo esc_html__( 'Redo', 'shopcatflow' ); ?></button>
                </div>
            </div>
            <ul id="wcm-category-list" class="wcm-category-list">
                <?php foreach ($categories as $category): ?>
                    <?php
                    $category_order = get_term_meta($category->term_id, 'shopc_category_order', true);
                    if ($category_order === '' || $category_order === false) {
                        $category_order = get_term_meta($category->term_id, 'wcm_category_order', true);
                        if ($category_order === '' || $category_order === false) { $category_order = 999; }
                    }
                    $product_count = (int) $category->count;
                    $indent_px     = max(0, (int) $category->level) * 20;
                    $is_root       = ((int) $category->level === 0);
                    ?>

                    <li class="wcm-category-item<?php echo $is_root ? ' wcm-collapsed' : ''; ?>"
                        data-category-id="<?php echo esc_attr($category->term_id); ?>"
                        data-order="<?php echo esc_attr($category_order); ?>"
                        data-level="<?php echo esc_attr($category->level); ?>"
                        data-parent-id="<?php echo esc_attr($category->parent); ?>"
                        <?php echo $is_root ? '' : 'style="display:none;"'; ?>>

                        <div class="wcm-drag-handle" title="<?php echo esc_attr__( 'Drag to reorder / change level', 'shopcatflow' ); ?>"></div>

                        <div class="wcm-category-info">
                            <?php if ($category->level > 0): ?>
                                <span class="wcm-tree-gutter" style="--wcm-level: <?php echo (int) $category->level; ?>;"></span>
                            <?php endif; ?>
                            <span class="wcm-category-name">
                                <?php echo esc_html($category->name); ?>
                            </span>

                            <?php if ($category->level > 0): ?>
                                <span class="wcm-category-level"><?php echo esc_html__( 'Level', 'shopcatflow' ); ?> <?php echo (int) $category->level; ?></span>
                            <?php endif; ?>
                            <span class="wcm-category-count">(<?php echo esc_html($product_count); ?> <?php echo esc_html__( 'items', 'shopcatflow' ); ?>)</span>
                        </div>

                        <div class="wcm-category-actions">
                            <?php if ($this->has_children($category->term_id)): ?>
                                <button type="button" class="wcm-toggle-children" data-category-id="<?php echo esc_attr($category->term_id); ?>" title="<?php echo esc_attr__( 'Toggle subcategories', 'shopcatflow' ); ?>">-</button>
                            <?php endif; ?>
                            <button type="button" class="wcm-delete-category" data-category-id="<?php echo esc_attr($category->term_id); ?>" title="<?php echo esc_attr__( 'Delete category', 'shopcatflow' ); ?>">×</button>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <div class="wcm-category-container" id="wcm-graph-view" style="display:none;">
            <div id="wcm-graph-toolbar" class="wcm-graph-toolbar">
                <div class="left">
                    <span class="hint"><?php echo esc_html__( 'In graph view you can drag a bubble over another to make it a child.', 'shopcatflow' ); ?></span>
                </div>
                <div class="right">
                    <button type="button" class="button wcm-graph-zoom-out" title="<?php echo esc_attr__( 'Zoom out', 'shopcatflow' ); ?>">−</button>
                    <button type="button" class="button wcm-graph-zoom-in" title="<?php echo esc_attr__( 'Zoom in', 'shopcatflow' ); ?>">+</button>
                    <button type="button" class="button wcm-graph-fit" title="<?php echo esc_attr__( 'Fit to screen', 'shopcatflow' ); ?>"><?php echo esc_html__( 'Fit', 'shopcatflow' ); ?></button>
                    <button type="button" class="button wcm-graph-reset" title="<?php echo esc_attr__( 'Reset', 'shopcatflow' ); ?>"><?php echo esc_html__( 'Reset', 'shopcatflow' ); ?></button>
                    <button type="button" class="button wcm-graph-rotate" title="<?php echo esc_attr__( 'Rotate', 'shopcatflow' ); ?>">⟳</button>
                    <button type="button" class="button wcm-graph-fullscreen" title="<?php echo esc_attr__( 'Fullscreen', 'shopcatflow' ); ?>"><?php echo esc_html__( 'Full', 'shopcatflow' ); ?></button>
                    <button type="button" class="button wcm-graph-undo" title="<?php echo esc_attr__( 'Undo (Ctrl/Cmd+Z)', 'shopcatflow' ); ?>">⟲ <?php echo esc_html__( 'Undo', 'shopcatflow' ); ?></button>
                    <button type="button" class="button wcm-graph-redo" title="<?php echo esc_attr__( 'Redo (Ctrl+Y / Ctrl+Shift+Z)', 'shopcatflow' ); ?>">⟳ <?php echo esc_html__( 'Redo', 'shopcatflow' ); ?></button>
                </div>
            </div>
            <svg id="wcm-graph-svg" width="100%" height="600"></svg>
        </div>

        <details class="wcm-help-text" style="margin-top:16px;">
            <summary><strong><?php echo esc_html__( 'How To Use', 'shopcatflow' ); ?></strong></summary>
            <ul>
                <li><strong><?php echo esc_html__( 'View Toggle:', 'shopcatflow' ); ?></strong> <?php echo esc_html__( 'Switch between List and Graph views with the buttons above; your latest choice persists during the session.', 'shopcatflow' ); ?></li>
                <li><strong><?php echo esc_html__( 'List Drag & Drop:', 'shopcatflow' ); ?></strong> <?php echo esc_html__( 'Grab the handle to reorder, move slightly left or right to change level, drop on the background to send a category to the root, and hover over a collapsed row to auto-expand it.', 'shopcatflow' ); ?></li>
                <li><strong><?php echo esc_html__( 'Selection & Bulk:', 'shopcatflow' ); ?></strong> <?php echo esc_html__( 'Filter by name, use Select visible, and work with per-row checkboxes for bulk delete (with optional child cascade); selections persist while you work.', 'shopcatflow' ); ?></li>
                <li><strong><?php echo esc_html__( 'Undo / Redo:', 'shopcatflow' ); ?></strong> <?php echo esc_html__( 'Use the Undo and Redo buttons (or Ctrl/Cmd+Z, Ctrl+Y / Ctrl+Shift+Z) to roll back up to ten recent reorder or reparent actions in either view.', 'shopcatflow' ); ?></li>
                <li><strong><?php echo esc_html__( 'Graph Reparent:', 'shopcatflow' ); ?></strong> <?php echo esc_html__( 'Drag a bubble over another category to make it a child, or drop it on empty space to return it to the root; colored halos show whether the drop is allowed.', 'shopcatflow' ); ?></li>
                <li><strong><?php echo esc_html__( 'Graph Navigation:', 'shopcatflow' ); ?></strong> <?php echo esc_html__( 'Pan by dragging the canvas, zoom with the mouse wheel or toolbar controls, and use Fit, Reset, or Rotate to quickly reframe the tree.', 'shopcatflow' ); ?></li>
                <li><strong><?php echo esc_html__( 'Fullscreen & Sync:', 'shopcatflow' ); ?></strong> <?php echo esc_html__( 'Press the Full button, double-click the background, or tap F to enter fullscreen; every change saves automatically and both views stay in sync.', 'shopcatflow' ); ?></li>
            </ul>
        </details>
    <?php endif; ?>
</div> 



