<?php
/**
 * Plugin Name: ShopCatFlow
 * Description: Manage WooCommerce product categories with drag-and-drop ordering and parent/child relationships.
 * Version: 1.0.1
 * Author: Ubermind
 * Author URI: https://profiles.wordpress.org/ubermind/
 * Text Domain: shopcatflow
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.8.2
 * WC requires at least: 5.0
 * WC tested up to: 10.2.1
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) { exit; }

define('SHOPC_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SHOPC_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('SHOPC_VERSION', '1.0.1');

require_once SHOPC_PLUGIN_PATH . 'includes/class-woocommerce-category-manager.php';

function shopc_woocommerce_missing_notice() {
    echo '<div class="error"><p><strong>ShopCatFlow</strong> ' . esc_html__('requires WooCommerce to be active.', 'shopcatflow') . '</p></div>';
}

function shopc_is_woocommerce_active() {
    return class_exists('WooCommerce') || defined('WC_ABSPATH') || did_action('woocommerce_loaded');
}

function shopc_boot() {
    if (!shopc_is_woocommerce_active()) {
        add_action('admin_notices', 'shopc_woocommerce_missing_notice');
        return;
    }
    new Shopcatflow_Category_Manager();
}
add_action('plugins_loaded', 'shopc_boot');

add_action('before_woocommerce_init', function () {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
    }
});

register_activation_hook(__FILE__, 'shopc_activate');
function shopc_activate() { flush_rewrite_rules(); }

register_deactivation_hook(__FILE__, 'shopc_deactivate');
function shopc_deactivate() { flush_rewrite_rules(); }