/* Minimal console instrumentation for WCM admin-ajax calls */
(function($){
    var enabled = true;
    try { if (window.localStorage && localStorage.getItem('wcm_debug')) { enabled = localStorage.getItem('wcm_debug') === '1'; } } catch(e){}
    if (window.shopc_ajax && typeof shopc_ajax.debug !== 'undefined') { enabled = !!shopc_ajax.debug; }
    function log(){ if (!enabled) return; if (window.console && console.log) try { console.log.apply(console, ['[WCM]'].concat([].slice.call(arguments))); } catch(e){ console.log('[WCM]', arguments); } }
    function warn(){ if (window.console && console.warn) try { console.warn.apply(console, ['[WCM]'].concat([].slice.call(arguments))); } catch(e){ console.warn('[WCM]', arguments); } }
    function err(){ if (window.console && console.error) try { console.error.apply(console, ['[WCM]'].concat([].slice.call(arguments))); } catch(e){ console.error('[WCM]', arguments); } }

    // Helper to extract 'action' from payload
    function parseData(data){
        if (!data) return {};
        if (typeof data === 'string') {
            try {
                // Convert querystring to object
                var o = {}; data.split('&').forEach(function(p){ var kv=p.split('='); if (kv[0]) o[decodeURIComponent(kv[0])] = decodeURIComponent((kv[1]||'').replace(/\+/g,' ')); });
                return o;
            } catch(e){ return {}; }
        }
        if (data && data.action) return data;
        return data;
    }

    // Global converter to strip UTF-8 BOM before JSON parse
    try {
        $.ajaxSetup({
            converters: {
                'text json': function(text){
                    try {
                        if (typeof text === 'string') {
                            var sanitized = text.replace(/\uFEFF/g, '');
                            if (sanitized !== text) { text = sanitized; }
                        }
                        return JSON.parse(text);
                    } catch (e) {
                        err('JSON parse failed', e, { preview: (text || '').slice(0, 200) });
                        throw e;
                    }
                }
            }
        });
    } catch(ex) { /* ignore */ }

    $(document).on('ajaxSend', function(e, jqXHR, ajax){
        var o = parseData(ajax && ajax.data);
        if (!o || !o.action || (o.action && o.action.indexOf('wcm_') !== 0)) return; // only log our actions
        log('ajaxSend', { action:o.action, url: ajax && ajax.url, data:o });
    });
    $(document).on('ajaxSuccess', function(e, jqXHR, ajax, data){
        var o = parseData(ajax && ajax.data);
        if (!o || !o.action || (o.action && o.action.indexOf('wcm_') !== 0)) return;
        if (data === -1 || data === "-1") { err('ajaxSuccess (nonce failed)', { action:o.action, body:data }); return; }
        log('ajaxSuccess', { action:o.action, response: data });
    });
    $(document).on('ajaxError', function(e, jqXHR, ajax, thrown){
        var o = parseData(ajax && ajax.data);
        if (!o || !o.action || (o.action && o.action.indexOf('wcm_') !== 0)) return;
        var body = (jqXHR && jqXHR.responseText) ? jqXHR.responseText.trim() : '';
        if (body === '-1') err('ajaxError (nonce failed)', { action:o.action, status: jqXHR && jqXHR.status });
        else if (body === '0') err('ajaxError (unknown error)', { action:o.action, status: jqXHR && jqXHR.status });
        else err('ajaxError', { action:o.action, status: jqXHR && jqXHR.status, body: body, thrown: thrown });
    });

    // First tick: announce debug active
    log('debug.js active', { ajax_defined: !!window.shopc_ajax, default_cat: window.shopc_ajax && shopc_ajax.default_category_id });
})(jQuery);