# ShopCatFlow

Streamlined drag-and-drop category management for WooCommerce with clear child/sibling previews, auto-save, and a compact, keyboard-friendly UI.

Contributors: ubermind
Requires at least: 5.0
Tested up to: 6.8
Stable tag: 1.0.1
Requires PHP: 7.4
License: GPL-2.0-or-later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

## Compatibility

- Tested with WooCommerce 10.2

## Features (List View)

- Smooth drag & drop reordering with clear "As child" / "As sibling" placeholder preview.
- Indent-aware level changes via slight horizontal movement; max level constraints preserved.
- Visual targeting: alignment markers indicate safe drop; list accepts drops without strict blocking.
- Auto-expand on stable hover over collapsed nodes (opens one level) to allow dropping inside.
- Root drop zone: move any category to top-level quickly.
- Undo/Redo (last 10 actions): reparent and reorder; toolbar buttons + keyboard shortcuts.
- Overlay + toast notifications for undo/redo and saves.
- Bulk operations: filter, select visible, bulk delete (optional cascade).
- State persistence: expansion and selection saved per session.
- Accessibility: toggle buttons include `aria-expanded`; delete buttons have `aria-label`s.
- Performance: colorization coalesced (idle scheduling) to reduce jank after refresh.

## Features (Graph View)

- Top-to-bottom tree layout (parents above, children below) with curved links.
- Fullscreen workspace toggle (toolbar, "F" key, double-click background).
- Smooth, normalized zoom with short easing steps; labels auto-scale at low zoom.
- Refit on switch from List → Graph; content fits viewport on first render.
- Drag-to-parent: drag a bubble onto another to make it a child; drop on background to make root. Undo/Redo supported.

## Shortcuts (Graph & List)

- Space + drag (Graph): Pan canvas
- Mouse wheel (Graph): Smooth zoom at pointer
- Arrow keys (Graph): Nudge view
- F (Graph): Toggle fullscreen
- Delete/Backspace (Graph): Delete selected node(s) with confirmation
- Ctrl/Cmd+Z: Undo (List & Graph)
- Ctrl+Y or Ctrl+Shift+Z: Redo (List & Graph)

## Installation

1. Upload the plugin to `/wp-content/plugins/shopcatflow/`.
2. Activate from WordPress > Plugins.
3. Go to WooCommerce > ShopCatFlow.

## Requirements

- WordPress 5.0+
- WooCommerce 5.0+
- PHP 7.4+

## Technical Notes

- Orders stored in `shopc_category_order` term meta (reads legacy `wcm_category_order` if present).
- AJAX endpoints secured with nonces and capability checks.
- jQuery UI Sortable used for list interactions.

## Source Code

The JavaScript and CSS files in this plugin are provided in their original, unminified form for transparency and review:

- `assets/js/admin.js` - Main admin interface JavaScript (1,137 lines)
- `assets/js/graph.js` - Graph view JavaScript with SVG rendering (1,150 lines) 
- `assets/js/debug.js` - Debug utilities
- `assets/css/admin.css` - Admin interface styles
- `assets/css/graph.css` - Graph view styles

All JavaScript code is written in vanilla JavaScript with jQuery dependencies. No build tools or minification are used - the code is distributed as-is for full transparency and easy review.

**Source Code Repository**: The complete source code is available in this plugin package. No external build process or minification tools are required to understand or modify the code.

## Changelog

- 1.0.1: Initial release. Updates: smoother list drag, hover auto-expand, visual markers, root drop zone; Undo/Redo (10-level), overlay + toasts; graph fullscreen, vertical layout, smooth zoom, label scaling, and auto-refit when switching views; performance tweaks for colorization.

## Author

- Author: Ubermind — https://profiles.wordpress.org/ubermind/
