<?php
/*
Plugin Name: Shop Order Quick Export
Description: Quickly export WooCommerce orders to CSV or Excel (XLSX) format. Select your date range and order status, then download with one click!
Version: 1.0
Author: Beni
License: GPLv2 or later
Text Domain: shop-order-quick-export
Domain Path: /languages
Requires Plugins: woocommerce
*/

if (!defined('ABSPATH'))
    exit;

/*
 * Process Export
 */
add_action('admin_init', function () {
    if (
        isset($_POST['soqe_export_csv']) ||
        isset($_POST['soqe_export_excel'])
    ) {
        // Nonce verification
        if (
            !isset($_POST['soqe_export_nonce']) ||
            !wp_verify_nonce(
                sanitize_text_field(wp_unslash($_POST['soqe_export_nonce'])),
                'soqe_export_action'
            )
        ) {
            wp_die(esc_html__('Invalid request.', 'shop-order-quick-export'));
        }

        if (!current_user_can('manage_woocommerce')) {
            wp_die(esc_html__('No permission.', 'shop-order-quick-export'));
        }

        $date_from = isset($_POST['date_from']) ? sanitize_text_field(wp_unslash($_POST['date_from'])) : '';
        $date_to = isset($_POST['date_to']) ? sanitize_text_field(wp_unslash($_POST['date_to'])) : '';
        $status = isset($_POST['status']) ? sanitize_text_field(wp_unslash($_POST['status'])) : '';
        include_once dirname(__FILE__) . '/includes/class-soqe-export.php';

        while (ob_get_level()) {
            ob_end_clean();
        }

        if (isset($_POST['soqe_export_csv'])) {
            SOQE_Export::generate_csv($date_from, $date_to, $status);
        } else {
            SOQE_Export::generate_excel($date_from, $date_to, $status);
        }
        exit;
    }
});

/*
 * Add Page to WooCommerce Menu
 */
add_action('admin_menu', 'soqe_add_admin_menu');
function soqe_add_admin_menu()
{
    add_submenu_page(
        'woocommerce',
        esc_html__('Export Orders', 'shop-order-quick-export'),
        esc_html__('Export Orders', 'shop-order-quick-export'),
        'manage_woocommerce',
        'soqe-export',
        'soqe_export_page_callback'
    );
}

/*
 * Export Page
 */
function soqe_export_page_callback()
{
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Export WooCommerce Orders', 'shop-order-quick-export'); ?></h1>
        <form method="post">
            <?php wp_nonce_field('soqe_export_action', 'soqe_export_nonce'); ?>
            <label for="date_from"><?php esc_html_e('From:', 'shop-order-quick-export'); ?></label>
            <input type="date" name="date_from" required>
            <label for="date_to"><?php esc_html_e('To:', 'shop-order-quick-export'); ?></label>
            <input type="date" name="date_to" required>
            <label for="status"><?php esc_html_e('Order Status:', 'shop-order-quick-export'); ?></label>
            <select name="status">
                <option value=""><?php esc_html_e('All', 'shop-order-quick-export'); ?></option>
                <option value="wc-completed"><?php esc_html_e('Completed', 'shop-order-quick-export'); ?></option>
                <option value="wc-processing"><?php esc_html_e('Processing', 'shop-order-quick-export'); ?></option>
                <option value="wc-on-hold"><?php esc_html_e('On hold', 'shop-order-quick-export'); ?></option>
                <option value="wc-cancelled"><?php esc_html_e('Cancelled', 'shop-order-quick-export'); ?></option>
                <option value="wc-refunded"><?php esc_html_e('Refunded', 'shop-order-quick-export'); ?></option>
                <option value="wc-failed"><?php esc_html_e('Failed', 'shop-order-quick-export'); ?></option>
                <option value="wc-pending"><?php esc_html_e('Pending payment', 'shop-order-quick-export'); ?></option>
            </select>
            <input type="submit" name="soqe_export_csv" class="button"
                value="<?php esc_attr_e('Export CSV', 'shop-order-quick-export'); ?>">
            <input type="submit" name="soqe_export_excel" class="button-primary"
                value="<?php esc_attr_e('Export Excel', 'shop-order-quick-export'); ?>">
        </form>
    </div>
    <?php
}
