<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://shipper360.io
 * @since             1.0
 * @package           Shipper360
 *
 * @wordpress-plugin
 * Plugin Name:       Shipper360
 * Description: Multi-carrier shipping solution for WooCommerce integrating ACS, Speedex, and Geniki couriers with real-time rates, label generation, and tracking.
 * Version:           1.0
 * Author:            Shipper
 * Author URI:        https://shipper360.io/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       shipper360
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'SHIPPER360_VERSION', '1.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-shipper360-activator.php
 */
function shipper360_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-shipper360-activator.php';
	Shipper360_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-shipper360-deactivator.php
 */
function shipper360_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-shipper360-deactivator.php';
	Shipper360_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'shipper360_activate' );
register_deactivation_hook( __FILE__, 'shipper360_deactivate' );
/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-shipper360.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0
 */
function shipper360_load() {

	$plugin = new Shipper360();
	$plugin->run();

}
shipper360_load();
