jQuery(document).ready(function($) {
    $('#shipper-tracking-form').on('submit', function(e) {
        e.preventDefault();
        
        var trackingCode = $('#tracking-code').val().trim();
        if (!trackingCode) {
            return;
        }

        $('#shipper-tracking-loading').show();
        $('#shipper-tracking-results').empty();

        $.ajax({
            url: shipper360_tracking_localize.ajax_url,
            type: 'POST',
            data: {
                action: 'shipper_track',
                tracking_code: trackingCode,
                nonce: shipper360_tracking_localize.nonce
            },
            success: function(response) {
                $('#shipper-tracking-loading').hide();
                if (response.success) {
                    displayTrackingResults(response.data);
                } else {
                    $('#shipper-tracking-results').html('<div class="shipper-error">' + response.data + '</div>');
                }
            },
            error: function() {
                $('#shipper-tracking-loading').hide();
                $('#shipper-tracking-results').html('<div class="shipper-error">' + shipper360_tracking_localize.error_message + '</div>');
            }
        });
    });

    function displayTrackingResults(data) {
        var html = '';
        
        if (!data.found) {
            html = '<div class="shipper-error">' + shipper360_tracking_localize.not_found_message + '</div>';
        } else {
            html += '<div class="shipper-tracking-info">';
            html += '<h4>' + shipper360_tracking_localize.tracking_info_title + '</h4>';
            html += '<p><strong>' + shipper360_tracking_localize.tracking_code_label + '</strong> ' + data.tracking_code + '</p>';
            html += '<p><strong>' + shipper360_tracking_localize.carrier_label + '</strong> ' + data.carrier + '</p>';
            
            if (data.tracking_events && data.tracking_events.length > 0) {
                html += '<h5>' + shipper360_tracking_localize.tracking_events_label + '</h5>';
                html += '<div class="shipper-tracking-events">';
                
                data.tracking_events.forEach(function(event) {
                    html += '<div class="tracking-event">';
                    html += '<div class="event-date">' + formatDateTime(event.date_time) + '</div>';
                    html += '<div class="event-status">' + event.status + '</div>';
                    if (event.location) {
                        html += '<div class="event-location">' + event.location + '</div>';
                    }
                    if (event.notes) {
                        html += '<div class="event-notes">' + event.notes + '</div>';
                    }
                    html += '</div>';
                });
                
                html += '</div>';
            }
            html += '</div>';
        }
        
        $('#shipper-tracking-results').html(html);
    }
    
    function formatDateTime(dateTimeString) {
        var date = new Date(dateTimeString);
        return date.toLocaleString();
    }
});