<?php
if (!defined('ABSPATH')) exit;

// Enqueue necessary styles for the card design
function shiperman_enqueue_card_styles()
{
    wp_enqueue_style('shiperman-card-styles', SMFWC_SHIPERMAN_PLUGIN_URL . 'assets/css/card-styles.css', [], SMFWC_SHIPERMAN_PLUGIN_VERSION);
}
add_action('wp_enqueue_scripts', 'shiperman_enqueue_card_styles');
add_action('admin_enqueue_scripts', 'shiperman_enqueue_card_styles');

do_action('shiperman_before_parcel_history_card');
?>
<!-- <div class="shiperman-container"> -->
<div class="shiperman-card">
    <div class="shiperman-card-header">
        <h2 class="shiperman-card-title"><?php esc_html_e('Recent Orders', 'shiperman-for-woocommerce'); ?></h2>
    </div>

    <div class="shiperman-card-content">
        <?php if (
            isset($recent_orders['status']) && 'success' === $recent_orders['status'] &&
            is_array($recent_orders['data']['items']) && !empty($recent_orders['data']['items'])
        ): ?>
            <div class="shiperman-orders-list">
                <?php
                $order_count = count($recent_orders['data']['items']);
                $index = 0;
                foreach ($recent_orders['data']['items'] as $order):
                    $order_status_code = $order['status'] ?? null;

                    $status_map = [
                        0 => 'Created',
                        1 => 'Processing',
                        2 => 'Successful'
                    ];

                    $color_map = [
                        0 => 'info',
                        1 => 'secondary',
                        2 => 'green'
                    ];

                    $order_status_text = isset($status_map[$order_status_code]) ? $status_map[$order_status_code] : 'Unknown';
                    $order_status_color = isset($color_map[$order_status_code]) ? $color_map[$order_status_code] : 'default';

                    $order_id = $order['internalId'] ?? '';
                    $reference_id = $order['referenceId'] ?? '';
                    $date_updated = isset($order['dateUpdated']) ? gmdate('Y-m-d H:i:s', $order['dateUpdated']) : '';
                    $recipient_name = isset($order['recipient']['name']) ? esc_html($order['recipient']['name']) : '';
                    $recipient_email = isset($order['recipient']['email']) ? esc_html($order['recipient']['email']) : '';
                ?>
                    <div class="shiperman-order-row" data-order-id="<?php echo esc_attr($order_id); ?>">
                        <div class="shiperman-order-avatar">
                            <img src="<?php echo esc_url(SMFWC_SHIPERMAN_PLUGIN_URL . 'assets/images/box.png'); ?>" alt="Package">
                        </div>
                        <div class="shiperman-order-details">
                            <div class="shiperman-order-title">Order <?php echo esc_html($order_id); ?> / <?php echo esc_html($reference_id); ?></div>
                            <div class="shiperman-order-date"><?php echo esc_html($date_updated); ?></div>
                        </div>
                        <div class="shiperman-order-recipient">
                            <?php echo esc_html($recipient_name); ?> / <?php echo esc_html($recipient_email); ?>
                        </div>
                        <div class="shiperman-order-action status-<?php echo esc_attr($order_status_color); ?>">
                            <?php echo esc_html($order_status_text); ?>
                        </div>
                    </div>
                    <?php if ($index < $order_count - 1): ?>
                        <div class="shiperman-divider"></div>
                    <?php endif; ?>
                <?php
                    $index++;
                endforeach;
                ?>
            </div>
        <?php else: ?>
            <div class="shiperman-no-orders">
                <div class="shiperman-no-orders-message">
                    <?php esc_html_e('No parcels found!', 'shiperman-for-woocommerce'); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="shiperman-divider"></div>

    <div class="shiperman-card-actions">
        <a href="<?php echo esc_url(admin_url('admin.php?page=shiperman_orders')); ?>" class="shiperman-btn-v2 shiperman-btn-primary">
            <?php esc_html_e('See All Orders', 'shiperman-for-woocommerce'); ?>
        </a>
    </div>
</div>
<!-- </div> -->
<?php do_action('shiperman_after_parcel_history_card'); ?>