<?php
if (!defined('ABSPATH')) exit;

// Function to get country name from country code
function shiperman_get_country_name($country_code)
{
    $countries = [
        'us' => 'United States',
        'ca' => 'Canada',
        'uk' => 'United Kingdom',
        'de' => 'Germany',
        'fr' => 'France'
    ];

    return isset($countries[strtolower($country_code)]) ? $countries[strtolower($country_code)] : $country_code;
}

// Inline function to create a data attribute for copying
function shiperman_address_data_attr($address)
{
    return esc_attr(json_encode($address));
}

// Enqueue necessary styles for the card design
function shiperman_enqueue_card_styles()
{
    wp_enqueue_style('shiperman-card-styles', SMFWC_SHIPERMAN_PLUGIN_URL . 'assets/css/card-styles.css', [], SMFWC_SHIPERMAN_PLUGIN_VERSION);
}
add_action('wp_enqueue_scripts', 'shiperman_enqueue_card_styles');
add_action('admin_enqueue_scripts', 'shiperman_enqueue_card_styles');

do_action('shiperman_before_parcel_history_card');

?>

<div class="shiperman-address-card-container">
    <?php if (!empty($depos_data) && is_array($depos_data)): ?>
        <?php foreach ($depos_data as $address): ?>
            <div class="shiperman-address-card">
                <div class="shiperman-card-header">
                    <div class="shiperman-card-header-prepend">
                        <div class="shiperman-avatar rounded-sm">
                            <img src="<?php echo esc_url(SMFWC_SHIPERMAN_PLUGIN_URL . 'assets/images/flags/' . strtolower($address['country']) . '.svg'); ?>"
                                alt="<?php echo esc_attr(shiperman_get_country_name($address['country'])); ?>" />
                        </div>
                    </div>

                    <div class="shiperman-card-title">
                        <?php echo esc_html(shiperman_get_country_name($address['country'])); ?>
                    </div>

                    <div class="shiperman-card-header-append">
                        <button class="shiperman-btn-icon copy-button"
                            data-address='<?php echo shiperman_address_data_attr($address); ?>'
                            title="Copy address details">
                            <span class="dashicons dashicons-clipboard"></span>
                        </button>
                    </div>
                </div>

                <?php if (!empty($address['note'])): ?>
                    <div class="shiperman-card-subtitle">
                        <div class="shiperman-alert info">
                            <span class="display-note"><?php echo esc_html($address['note']); ?></span>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="shiperman-card-content">
                    <p class="text-body-1">
                        <span class="shiperman-icon account-icon"></span> <?php echo esc_html($address['senderName']); ?> <br>
                        <span class="shiperman-icon city-icon"></span> <?php echo esc_html($address['address']); ?>, <?php echo esc_html($address['city']); ?>, <?php echo esc_html($address['zip']); ?><br>
                        <span class="shiperman-icon warehouse-icon"></span> <?php echo esc_html(shiperman_get_country_name($address['country'])); ?>
                    </p>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="notice notice-error is-dismissible">
            <p><?php esc_html_e('No deposit data found.', 'shiperman-for-woocommerce'); ?></p>
        </div>
    <?php endif; ?>
</div>

<script>
    // Add JavaScript for the copy functionality
    document.addEventListener('DOMContentLoaded', function() {
        const copyButtons = document.querySelectorAll('.copy-button');

        copyButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();

                // Get address data from data attribute
                const addressData = JSON.parse(this.getAttribute('data-address'));

                // Format the address for copying
                const formattedAddress =
                    addressData.senderName + '\n' +
                    addressData.address + '\n' +
                    addressData.city + ', ' + addressData.zip + '\n' +
                    shiperman_get_country_name(addressData.country);

                // Copy to clipboard
                navigator.clipboard.writeText(formattedAddress).then(() => {
                    // Show a tooltip or notification that the copy was successful
                    const originalTitle = this.getAttribute('title');
                    this.setAttribute('title', 'Copied!');

                    // Reset tooltip after 2 seconds
                    setTimeout(() => {
                        this.setAttribute('title', originalTitle);
                    }, 2000);
                });
            });
        });

        // Add hover effect
        const addressCards = document.querySelectorAll('.shiperman-address-card');

        addressCards.forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.classList.add('elevation-4');
            });

            card.addEventListener('mouseleave', function() {
                this.classList.remove('elevation-4');
            });
        });
    });

    // If you need to define the country name function in JavaScript as well
    function shiperman_get_country_name(countryCode) {
        const countries = {
            'us': 'United States',
            'ca': 'Canada',
            'uk': 'United Kingdom',
            'de': 'Germany',
            'fr': 'France',
            // Add more countries as needed
        };

        return countries[countryCode.toLowerCase()] || countryCode;
    }
</script>