<?php
/**
 * Plugin Name: Shibhu Custom Messages for WooCommerce
 * Description: Display custom messages, timers, stock counters, and more on WooCommerce product pages with advanced conditional logic.
 * Version: 1.1.0
 * Author: shibhuplugins
 * Text Domain: shibhu-custom-messages-for-woocommerce
 * Requires Plugins: woocommerce
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 8.5
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// Prevent direct access
defined( 'ABSPATH' ) || exit;

// Define plugin constants
define( 'SCMW_VERSION', '1.0.0' );
define( 'SCMW_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SCMW_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'SCMW_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Main Plugin Class
 */
class Shibhu_Custom_Messages_For_WooCommerce {
    
    private static $instance = null;
    
    /**
     * Singleton instance
     */
    public static function get_instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Constructor
     */
    private function __construct() {
        $this->includes();
        $this->init_hooks();
    }
    
    /**
     * Include required files
     */
    private function includes() {
        require_once SCMW_PLUGIN_DIR . 'includes/class-scmw-post-type.php';
        require_once SCMW_PLUGIN_DIR . 'includes/class-scmw-conditional-logic.php';
        require_once SCMW_PLUGIN_DIR . 'includes/class-scmw-meta-boxes.php';
        require_once SCMW_PLUGIN_DIR . 'includes/class-scmw-frontend.php';
        require_once SCMW_PLUGIN_DIR . 'includes/class-scmw-shortcodes.php';
        require_once SCMW_PLUGIN_DIR . 'includes/class-scmw-discount-styles.php';
    }
    
    /**
     * Initialize hooks
     */
    private function init_hooks() {
        add_action( 'init', array( $this, 'init' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'frontend_scripts' ) );
        
        // Activation/Deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
    }
    
        
    /**
     * Initialize plugin components
     */
    public function init() {
        SCMW_Post_Type::get_instance();
        SCMW_Conditional_Logic::get_instance();
        SCMW_Meta_Boxes::get_instance();
        SCMW_Frontend::get_instance();
        SCMW_Shortcodes::get_instance();
    }
    
    /**
     * Enqueue admin scripts
     */
    public function admin_scripts( $hook ) {
        global $post_type;
        
        if ( ( 'post.php' === $hook || 'post-new.php' === $hook ) && 'scmw_message' === $post_type ) {
            // Admin CSS
            wp_enqueue_style(
                'scmw-admin-css',
                SCMW_PLUGIN_URL . 'assets/css/admin.css',
                array(),
                SCMW_VERSION
            );
            
            // Color picker
            wp_enqueue_style( 'wp-color-picker' );
            
            // Media uploader
            wp_enqueue_media();
            
            // Admin JS
            wp_enqueue_script(
                'scmw-admin-js',
                SCMW_PLUGIN_URL . 'assets/js/admin.js',
                array( 'jquery', 'wp-color-picker' ),
                SCMW_VERSION,
                true
            );
            
            // Localize script
            wp_localize_script( 'scmw-admin-js', 'scmwAdmin', array(
                'ajaxurl' => admin_url( 'admin-ajax.php' ),
                'nonce'   => wp_create_nonce( 'scmw_admin_nonce' ),
                'strings' => array(
                    'confirmRemoveGroup'     => __( 'Are you sure you want to remove this group?', 'shibhu-custom-messages-for-woocommerce' ),
                    'confirmRemoveCondition' => __( 'Are you sure you want to remove this condition?', 'shibhu-custom-messages-for-woocommerce' ),
                    'selectImage'            => __( 'Select Image', 'shibhu-custom-messages-for-woocommerce' ),
                    'useImage'               => __( 'Use Image', 'shibhu-custom-messages-for-woocommerce' ),
                    'selectCategory'         => __( 'Select Category...', 'shibhu-custom-messages-for-woocommerce' ),
                    'selectTag'              => __( 'Select Tag...', 'shibhu-custom-messages-for-woocommerce' ),
                ),
            ) );
        }
    }
    
    /**
     * Enqueue frontend scripts
     */
    public function frontend_scripts() {
        if ( is_product() ) {
            // Frontend CSS
            wp_enqueue_style(
                'scmw-frontend-css',
                SCMW_PLUGIN_URL . 'assets/css/frontend.css',
                array(),
                SCMW_VERSION
            );
            
            // Frontend JS
            wp_enqueue_script(
                'scmw-frontend-js',
                SCMW_PLUGIN_URL . 'assets/js/frontend.js',
                array( 'jquery' ),
                SCMW_VERSION,
                true
            );
            
            // Localize script
            wp_localize_script( 'scmw-frontend-js', 'scmwFrontend', array(
                'ajaxurl' => admin_url( 'admin-ajax.php' ),
                'nonce'   => wp_create_nonce( 'scmw_frontend_nonce' ),
                'strings' => array(
                    'copied'      => __( 'Copied!', 'shibhu-custom-messages-for-woocommerce' ),
                    'copyFailed'  => __( 'Copy failed', 'shibhu-custom-messages-for-woocommerce' ),
                    'shareTitle'  => __( 'Share this product', 'shibhu-custom-messages-for-woocommerce' ),
                ),
            ) );
        }
    }
    
    /**
     * Plugin activation
     */
    public function activate() {
                
        // Flush rewrite rules
        flush_rewrite_rules();
        
        // Set default options
        if ( ! get_option( 'scmw_version' ) ) {
            update_option( 'scmw_version', SCMW_VERSION );
        }
    }
    
    /**
     * Plugin deactivation
     */
    public function deactivate() {
        flush_rewrite_rules();
    }
}

/**
 * Initialize the plugin
 */
function scmw_init() {
    return Shibhu_Custom_Messages_For_WooCommerce::get_instance();
}

// Start the plugin
scmw_init();
