<?php
/**
 * Shortcodes Handler
 *
 * @package Shibhu Custom Messages for WooCommerce
 */

defined( 'ABSPATH' ) || exit;

class SCMW_Shortcodes {
    
    private static $instance = null;
    
    public static function get_instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        // No shortcodes to register - we handle replacements in templates
        // But we keep this class for future shortcode functionality
    }
    
    /**
     * Replace shortcodes in text (used by frontend class)
     * This is a utility function for internal use
     * 
     * @param string     $text    Text with shortcodes
     * @param WC_Product $product Product object
     * @return string Text with shortcodes replaced
     */
    public static function replace_in_text( $text, $product ) {
        if ( ! $product ) {
            return $text;
        }
        
        $replacements = array(
            '{product_name}'  => $product->get_name(),
            '{product_price}' => wc_price( $product->get_price() ),
            '{stock_count}'   => $product->get_stock_quantity() !== null ? absint( $product->get_stock_quantity() ) : 0,
            '{product_sku}'   => $product->get_sku(),
            '{product_url}'   => get_permalink( $product->get_id() ),
        );
        
        // Allow filtering of shortcode replacements
        $replacements = apply_filters( 'scmw_shortcode_replacements', $replacements, $product );
        
        return str_replace( array_keys( $replacements ), array_values( $replacements ), $text );
    }
    
    /**
     * Get list of available shortcodes with descriptions
     * 
     * @return array Available shortcodes
     */
    public static function get_available_shortcodes() {
        $shortcodes = array(
            '{product_name}'  => __( 'Product name', 'shibhu-custom-messages-for-woocommerce' ),
            '{product_price}' => __( 'Product price (formatted)', 'shibhu-custom-messages-for-woocommerce' ),
            '{stock_count}'   => __( 'Stock quantity', 'shibhu-custom-messages-for-woocommerce' ),
            '{product_sku}'   => __( 'Product SKU', 'shibhu-custom-messages-for-woocommerce' ),
            '{product_url}'   => __( 'Product URL', 'shibhu-custom-messages-for-woocommerce' ),
            '{countdown}'     => __( 'Countdown timer placeholder', 'shibhu-custom-messages-for-woocommerce' ),
        );
        
        return apply_filters( 'scmw_available_shortcodes', $shortcodes );
    }
}