<?php
/**
 * Custom Post Type Handler
 *
 * @package Shibhu Custom Messages for WooCommerce
 */

defined( 'ABSPATH' ) || exit;

class SCMW_Post_Type {
    
    private static $instance = null;
    
    public static function get_instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function __construct() {
        add_action( 'init', array( $this, 'register_post_type' ) );
        add_filter( 'manage_scmw_message_posts_columns', array( $this, 'add_columns' ) );
        add_action( 'manage_scmw_message_posts_custom_column', array( $this, 'column_content' ), 10, 2 );
    }
    
    /**
     * Register custom post type
     */
    public static function register_post_type() {
        $labels = array(
            'name'                  => _x( 'Product Messages', 'Post Type General Name', 'shibhu-custom-messages-for-woocommerce' ),
            'singular_name'         => _x( 'Product Message', 'Post Type Singular Name', 'shibhu-custom-messages-for-woocommerce' ),
            'menu_name'             => __( 'Product Messages', 'shibhu-custom-messages-for-woocommerce' ),
            'name_admin_bar'        => __( 'Product Message', 'shibhu-custom-messages-for-woocommerce' ),
            'archives'              => __( 'Message Archives', 'shibhu-custom-messages-for-woocommerce' ),
            'attributes'            => __( 'Message Attributes', 'shibhu-custom-messages-for-woocommerce' ),
            'parent_item_colon'     => __( 'Parent Message:', 'shibhu-custom-messages-for-woocommerce' ),
            'all_items'             => __( 'All Messages', 'shibhu-custom-messages-for-woocommerce' ),
            'add_new_item'          => __( 'Add New Message', 'shibhu-custom-messages-for-woocommerce' ),
            'add_new'               => __( 'Add New', 'shibhu-custom-messages-for-woocommerce' ),
            'new_item'              => __( 'New Message', 'shibhu-custom-messages-for-woocommerce' ),
            'edit_item'             => __( 'Edit Message', 'shibhu-custom-messages-for-woocommerce' ),
            'update_item'           => __( 'Update Message', 'shibhu-custom-messages-for-woocommerce' ),
            'view_item'             => __( 'View Message', 'shibhu-custom-messages-for-woocommerce' ),
            'view_items'            => __( 'View Messages', 'shibhu-custom-messages-for-woocommerce' ),
            'search_items'          => __( 'Search Message', 'shibhu-custom-messages-for-woocommerce' ),
            'not_found'             => __( 'Not found', 'shibhu-custom-messages-for-woocommerce' ),
            'not_found_in_trash'    => __( 'Not found in Trash', 'shibhu-custom-messages-for-woocommerce' ),
            'featured_image'        => __( 'Message Image', 'shibhu-custom-messages-for-woocommerce' ),
            'set_featured_image'    => __( 'Set message image', 'shibhu-custom-messages-for-woocommerce' ),
            'remove_featured_image' => __( 'Remove message image', 'shibhu-custom-messages-for-woocommerce' ),
            'use_featured_image'    => __( 'Use as message image', 'shibhu-custom-messages-for-woocommerce' ),
            'insert_into_item'      => __( 'Insert into message', 'shibhu-custom-messages-for-woocommerce' ),
            'uploaded_to_this_item' => __( 'Uploaded to this message', 'shibhu-custom-messages-for-woocommerce' ),
            'items_list'            => __( 'Messages list', 'shibhu-custom-messages-for-woocommerce' ),
            'items_list_navigation' => __( 'Messages list navigation', 'shibhu-custom-messages-for-woocommerce' ),
            'filter_items_list'     => __( 'Filter messages list', 'shibhu-custom-messages-for-woocommerce' ),
        );
        
        $args = array(
            'label'                 => __( 'Product Message', 'shibhu-custom-messages-for-woocommerce' ),
            'description'           => __( 'Custom messages for WooCommerce products', 'shibhu-custom-messages-for-woocommerce' ),
            'labels'                => $labels,
            'supports'              => array( 'title' ),
            'hierarchical'          => false,
            'public'                => false,
            'show_ui'               => true,
            'show_in_menu'          => true,
            'menu_position'         => 56,
            'menu_icon'             => 'dashicons-megaphone',
            'show_in_admin_bar'     => true,
            'show_in_nav_menus'     => false,
            'can_export'            => true,
            'has_archive'           => false,
            'exclude_from_search'   => true,
            'publicly_queryable'    => false,
            'capability_type'       => 'post',
            'show_in_rest'          => false,
        );
        
        register_post_type( 'scmw_message', $args );
    }
    
    /**
     * Add custom columns
     */
    public function add_columns( $columns ) {
        $new_columns = array();
        $new_columns['cb'] = $columns['cb'];
        $new_columns['title'] = $columns['title'];
        $new_columns['message_type'] = __( 'Type', 'shibhu-custom-messages-for-woocommerce' );
        $new_columns['display_position'] = __( 'Position', 'shibhu-custom-messages-for-woocommerce' );
        $new_columns['conditions'] = __( 'Conditions', 'shibhu-custom-messages-for-woocommerce' );
        $new_columns['status'] = __( 'Status', 'shibhu-custom-messages-for-woocommerce' );
        $new_columns['date'] = $columns['date'];
        
        return $new_columns;
    }
    
    /**
     * Display column content
     */
    public function column_content( $column, $post_id ) {
        // Prevent duplicate output
        static $processed = array();
        
        $key = $post_id . '_' . $column;
        if ( isset( $processed[ $key ] ) ) {
            return;
        }
        $processed[ $key ] = true;
        
        switch ( $column ) {
            case 'message_type':
                $type = get_post_meta( $post_id, '_scmw_message_type', true );
                $types = array(
                    'text_ticker'    => __( 'Text Ticker', 'shibhu-custom-messages-for-woocommerce' ),
                    'stock_counter'  => __( 'Stock Counter', 'shibhu-custom-messages-for-woocommerce' ),
                    'countdown'      => __( 'Countdown Timer', 'shibhu-custom-messages-for-woocommerce' ),
                    'custom_image'   => __( 'Custom Image', 'shibhu-custom-messages-for-woocommerce' ),
                    'custom_message' => __( 'Custom Message', 'shibhu-custom-messages-for-woocommerce' ),
                    'discount_code'  => __( 'Discount Code', 'shibhu-custom-messages-for-woocommerce' ),
                    'social_share'   => __( 'Social Share', 'shibhu-custom-messages-for-woocommerce' ),
                );
                echo esc_html( isset( $types[ $type ] ) ? $types[ $type ] : __( 'N/A', 'shibhu-custom-messages-for-woocommerce' ) );
                break;
                
            case 'display_position':
                $position = get_post_meta( $post_id, '_scmw_display_position', true );
                $positions = array(
                    'before_title'       => __( 'Before Title', 'shibhu-custom-messages-for-woocommerce' ),
                    'after_title'        => __( 'After Title', 'shibhu-custom-messages-for-woocommerce' ),
                    'before_price'       => __( 'Before Price', 'shibhu-custom-messages-for-woocommerce' ),
                    'after_price'        => __( 'After Price', 'shibhu-custom-messages-for-woocommerce' ),
                    'before_add_to_cart' => __( 'Before Add to Cart', 'shibhu-custom-messages-for-woocommerce' ),
                    'after_add_to_cart'  => __( 'After Add to Cart', 'shibhu-custom-messages-for-woocommerce' ),
                    'before_tabs'        => __( 'Before Tabs', 'shibhu-custom-messages-for-woocommerce' ),
                    'after_tabs'         => __( 'After Tabs', 'shibhu-custom-messages-for-woocommerce' ),
                );
                echo esc_html( isset( $positions[ $position ] ) ? $positions[ $position ] : __( 'N/A', 'shibhu-custom-messages-for-woocommerce' ) );
                break;
                
            case 'conditions':
                $conditions = get_post_meta( $post_id, '_scmw_conditions', true );
                if ( ! empty( $conditions ) && is_array( $conditions ) ) {
                    $total_groups = count( $conditions );
                    $total_conditions = 0;
                    foreach ( $conditions as $group ) {
                        $total_conditions += count( $group );
                    }
                    // translators: 1: number of condition groups, 2: number of total conditions
                    printf( esc_html__( '%1$d groups / %2$d conditions', 'shibhu-custom-messages-for-woocommerce' ), 
                        absint( $total_groups ), 
                        absint( $total_conditions ) 
                    );
                } else {
                    esc_html_e( 'No conditions', 'shibhu-custom-messages-for-woocommerce' );
                }
                break;
                
            case 'status':
                $enabled = get_post_meta( $post_id, '_scmw_enabled', true );
                if ( $enabled === '1' || $enabled === 1 ) {
                    echo '<span style="color: green;">● ' . esc_html__( 'Enabled', 'shibhu-custom-messages-for-woocommerce' ) . '</span>';
                } else {
                    echo '<span style="color: #ccc;">○ ' . esc_html__( 'Disabled', 'shibhu-custom-messages-for-woocommerce' ) . '</span>';
                }
                break;
        }
    }
}

new SCMW_Post_Type();