<?php

/**
 * Handle development-specific scripts for SheetPoet
 * This file is only loaded in development mode and excluded from production builds
 *
 * @since     1.0.0
 */

defined('ABSPATH') || exit;

class SPGS_Assets_Dev
{
    /**
     * Enqueue development scripts and styles
     * Uses direct script tags for Vite development server compatibility
     *
     * @param string $apiNonce
     * @param string $root
     * @param string $baseUrl
     * @since 1.0.0
     */
    public static function enqueue_dev_assets( $apiNonce, $root, $baseUrl ) {
        echo '<script>console.log("Running in development mode");</script>';

        // Development mode: Use a dummy script handle to attach inline scripts
        wp_register_script('spgs-dev-config', '', array(), SPGS_VERSION, false);
        wp_enqueue_script('spgs-dev-config');

        // Add global configuration as inline script
        $config_script = sprintf(
            'var spgs = {
                apiNonce: %s,
                root: %s,
                baseUrl: %s
            };',
            wp_json_encode($apiNonce),
            wp_json_encode($root),
            wp_json_encode($baseUrl)
        );
        wp_add_inline_script('spgs-dev-config', $config_script, 'before');

        // React Refresh runtime needs to be loaded as a module script
        // Cannot be added as inline script due to ES module syntax

        // Note: Vite client and main module scripts still need to be loaded directly
        // as WordPress doesn't support ES modules with wp_enqueue_script
        add_action('admin_footer', function () {
            echo '<script type="module">
                import RefreshRuntime from "http://localhost:5178/@react-refresh";
                RefreshRuntime.injectIntoGlobalHook(window);
                window.$RefreshReg$ = () => {};
                window.$RefreshSig$ = () => (type) => type;
                window.__vite_plugin_react_preamble_installed__ = true;
            </script>';
            echo '<script type="module" src="http://localhost:5178/@vite/client"></script>';
            echo '<script type="module" src="http://localhost:5178/src/main.tsx"></script>';
        });
    }
}
