<?php
/**
 * Plugin Name: Share with AI
 * Plugin URI: https://www.digitall.com.tr
 * Description: Add buttons to share your post URLs directly with AI tools like ChatGPT, Gemini, Perplexity, and Claude.
 * Version: 1.0
 * Author: Savaş Şahin
 * Author URI: https://www.savassahin.com
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: share-with-ai
 */

if (!defined('ABSPATH')) exit;

function swai_enqueue_styles() {
    wp_enqueue_style(
        'swai-style',
        plugin_dir_url(__FILE__) . 'assets/style.css',
        array(),
        '1.0.0'
    );
}
add_action('wp_enqueue_scripts', 'swai_enqueue_styles');


function swai_render_buttons($content) {
    if (!is_single()) return $content;

    global $post;
    $post_url = get_permalink($post->ID);
    
    $buttons = '
    <div class="swai-buttons">
        <a href="https://chat.openai.com/share?url=' . urlencode($post_url) . '" target="_blank" rel="noopener">🤖 Share with ChatGPT</a>
        <a href="https://gemini.google.com/?url=' . urlencode($post_url) . '" target="_blank" rel="noopener">🔮 Share with Gemini</a>
        <a href="https://www.perplexity.ai/search?q=' . urlencode($post_url) . '" target="_blank" rel="noopener">🧠 Share with Perplexity</a>
        <a href="https://claude.ai/?prompt=' . urlencode($post_url) . '" target="_blank" rel="noopener">💡 Share with Claude</a>
    </div>
    ';

    return $buttons . $content;
}
add_filter('the_content', 'swai_render_buttons');
