<?php
/**
 * Plugin Name: Shapes Smart Scroll Animations
 * Description: Adds high-performance entrance animations (slide-up, zoom-out) with Smart Grid Delay and Accessibility support.
 * Version: 1.0.7
 * Author: lkdsgnr
 * Author URI: https://shps.pl
 * Text Domain: shapes-smart-scroll-animations
 * License: GPLv2 or later
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

/**
 * ENQUEUE SCRIPTS AND STYLES
 */
function shps_enqueue_plugin_assets() {
    
    // 1. Loading CSS
    wp_enqueue_style(
        'shps-styles', // Unique handle
        plugin_dir_url(__FILE__) . 'plugin-assets/css/shapes-smart-scroll-animations.css',
        array(), // Dependencies (none)
        '1.0.1', // Version
        'all' // Media
    );

    // 2. Loading JS
    wp_enqueue_script(
        'shps-scripts', // Unique handle
        plugin_dir_url(__FILE__) . 'plugin-assets/js/shapes-smart-scroll-animations.js',
        array(), // Dependencies (none, because it's Vanilla JS)
        '1.0.1', // Version
        array(
            'strategy'  => 'defer', // Performance optimization based on feedback
            'in_footer' => true, // Force footer loading - crucial for performance!
        )
    );

    /// Adding a class via API
    $inline_js = "document.documentElement.classList.add('shps-js-enabled');";
    wp_add_inline_script('shps-scripts', $inline_js, 'before');

}
add_action('wp_enqueue_scripts', 'shps_enqueue_plugin_assets');