/**
 * Professional Chatbot Logic - Frontend
 */
jQuery(document).ready(function($) {
    
    // 1. Toggle Logic (Fixes Click Issue)
    function slcp_toggle() {
        var $box = $('#slcp_box');
        if ($box.length) {
            $box.fadeToggle(200);
        }
    }

    // Event Listeners for Toggle Buttons
    $(document).on('click', '#slcp_toggle_btn, #slcp_close_btn', function(e) {
        e.preventDefault();
        slcp_toggle();
    });

    // 2. Auto-Open Feature (Strict Fix)
    if (typeof slcp_vars !== 'undefined' && slcp_vars.auto_open > 0) {
        setTimeout(function() {
            var $box = $('#slcp_box');
            if ($box.length && $box.is(':hidden')) {
                $box.fadeIn(300);
            }
        }, slcp_vars.auto_open);
    }

    // 3. Form Submission & Lead Capture
    $(document).on('click', '#slcp_start_chat', function(e) {
        e.preventDefault();
        var n = $('#sn').val().trim(), p = $('#sp').val().trim(), e_mail = $('#se').val().trim(), d = $('#sd').val(), dt = $('#sd option:selected').text();

        if (!n || !p || !d) { alert('Please fill all required fields (*)'); return; }

        $.post(slcp_vars.ajax_url, {
            action: 'slcp_save_lead',
            nonce: slcp_vars.nonce,
            name: n, phone: p, email: e_mail, dept: dt, source: document.referrer || 'Direct', url: window.location.href
        }, function() {
            window.open("https://wa.me/" + d.replace(/\D/g, '') + "?text=" + encodeURIComponent("Hi, I am " + n), '_blank');
            slcp_toggle();
        });
    });
});