<?php
if (!defined('ABSPATH')) {
    exit;
}

class ShadowScan_Storage {
    private const PREFIX = 'shadowscan_';

    public static function get(string $key, $default = null) {
        $value = get_option(self::PREFIX . $key, null);
        return $value === null ? $default : $value;
    }

    public static function set(string $key, $value): bool {
        return update_option(self::PREFIX . $key, $value, false);
    }

    public static function delete(string $key): bool {
        return delete_option(self::PREFIX . $key);
    }

    public static function get_json(string $key, $default = null) {
        $raw = self::get($key, null);
        if (!is_string($raw) || $raw === '') {
            return $default;
        }
        $decoded = json_decode($raw, true);
        return is_array($decoded) ? $decoded : $default;
    }

    public static function set_json(string $key, array $value): bool {
        return self::set($key, wp_json_encode($value));
    }
}
