<?php
if (!defined('ABSPATH')) {
    exit;
}

class ShadowScan_Signal_Config {
    public static function debug_enabled(): void {
        ShadowScan_Signal_Manager::emit(
            'CONFIG_DEBUG_ENABLED',
            'warning',
            'WP_DEBUG is enabled',
            array()
        );
    }

    public static function weak_file_perms(string $relative_path, string $mode): void {
        ShadowScan_Signal_Manager::emit(
            'CONFIG_WEAK_FILE_PERMS',
            'warning',
            'File permissions are too permissive',
            array('path' => $relative_path, 'mode' => $mode)
        );
    }

    public static function outdated_core(string $current, string $latest): void {
        ShadowScan_Signal_Manager::emit(
            'HYGIENE_OUTDATED_CORE',
            'warning',
            'WordPress core is outdated',
            array('current' => $current, 'latest' => $latest)
        );
    }

    public static function outdated_plugins(array $plugins): void {
        ShadowScan_Signal_Manager::emit(
            'HYGIENE_OUTDATED_PLUGINS',
            'info',
            'Outdated plugins detected',
            array('plugins' => $plugins)
        );
    }

    public static function abandoned_plugin(string $plugin): void {
        ShadowScan_Signal_Manager::emit(
            'HYGIENE_ABANDONED_PLUGIN',
            'info',
            'Potentially abandoned plugin detected',
            array('plugin' => $plugin)
        );
    }
}
