<?php
if (!defined('ABSPATH')) {
    exit;
}

class ShadowScan_Signal_Auth {
    public static function brute_force_suspected(int $count, int $window_minutes): void {
        ShadowScan_Signal_Manager::emit(
            'AUTH_BRUTE_FORCE_SUSPECTED',
            'medium',
            'Login anomalies detected',
            array(
                'count' => $count,
                'window_minutes' => $window_minutes,
            )
        );
    }

    public static function new_admin_created(int $user_id): void {
        ShadowScan_Signal_Manager::emit(
            'AUTH_NEW_ADMIN_CREATED',
            'warning',
            'New administrator account created',
            array('user_id' => $user_id)
        );
    }

    public static function role_changed(int $user_id, string $old_role, string $new_role): void {
        ShadowScan_Signal_Manager::emit(
            'AUTH_ROLE_CHANGED',
            'info',
            'User role changed',
            array(
                'user_id' => $user_id,
                'old_role' => $old_role,
                'new_role' => $new_role,
            )
        );
    }

    public static function user_locked(int $user_id, int $locked_until): void {
        ShadowScan_Signal_Manager::emit(
            'AUTH_USER_LOCKED',
            'medium',
            'User temporarily locked after anomalies',
            array(
                'user_id' => $user_id,
                'locked_until' => $locked_until,
            )
        );
    }

    public static function lock_skipped_last_admin(int $user_id): void {
        ShadowScan_Signal_Manager::emit(
            'AUTH_LOCK_SKIPPED_LAST_ADMIN',
            'high',
            'Auth lock skipped for last admin',
            array('user_id' => $user_id)
        );
    }
}
