<?php
if (!defined('ABSPATH')) {
    exit;
}

class ShadowScan_Rate_Limiter {
    public static function increment(string $state_key, string $bucket, int $window_seconds): int {
        $state = ShadowScan_Storage::get_json($state_key, array());
        if (!is_array($state)) {
            $state = array();
        }

        $now = time();
        $entries = isset($state[$bucket]) && is_array($state[$bucket]) ? $state[$bucket] : array();
        $entries[] = $now;
        $entries = self::prune($entries, $now - $window_seconds);
        $state[$bucket] = $entries;
        ShadowScan_Storage::set_json($state_key, $state);
        return count($entries);
    }

    public static function count(string $state_key, string $bucket, int $window_seconds): int {
        $state = ShadowScan_Storage::get_json($state_key, array());
        if (!is_array($state)) {
            return 0;
        }
        $entries = isset($state[$bucket]) && is_array($state[$bucket]) ? $state[$bucket] : array();
        $entries = self::prune($entries, time() - $window_seconds);
        $state[$bucket] = $entries;
        ShadowScan_Storage::set_json($state_key, $state);
        return count($entries);
    }

    public static function reset(string $state_key, string $bucket): void {
        $state = ShadowScan_Storage::get_json($state_key, array());
        if (!is_array($state)) {
            return;
        }
        if (array_key_exists($bucket, $state)) {
            unset($state[$bucket]);
            ShadowScan_Storage::set_json($state_key, $state);
        }
    }

    private static function prune(array $entries, int $cutoff): array {
        return array_values(array_filter($entries, function ($timestamp) use ($cutoff) {
            return (int) $timestamp >= $cutoff;
        }));
    }
}
