<?php
if (!defined('ABSPATH')) {
    exit;
}

class ShadowScan_Signal_Integrity {
    public static function new_php_in_uploads(string $relative_path): void {
        ShadowScan_Signal_Manager::emit(
            'INTEGRITY_NEW_PHP_IN_UPLOADS',
            'warning',
            'New PHP file detected in uploads',
            array('path' => $relative_path)
        );
    }

    public static function core_file_changed(string $relative_path): void {
        ShadowScan_Signal_Manager::emit(
            'INTEGRITY_CORE_FILE_CHANGED',
            'warning',
            'Core file hash changed',
            array('path' => $relative_path)
        );
    }

    public static function plugin_file_changed(string $relative_path): void {
        ShadowScan_Signal_Manager::emit(
            'INTEGRITY_PLUGIN_FILE_CHANGED',
            'info',
            'Plugin file hash changed',
            array('path' => $relative_path)
        );
    }

    public static function suspicious_path_writable(string $relative_path): void {
        ShadowScan_Signal_Manager::emit(
            'INTEGRITY_SUSPICIOUS_PATH_WRITABLE',
            'warning',
            'Suspicious path is writable',
            array('path' => $relative_path)
        );
    }
}
