<?php
if (!defined('ABSPATH')) {
    exit;
}

return array(
    array(
        'category_id' => 'A01',
        'title' => 'Broken Access Control',
        'description' => 'WordPress roles, permissions, REST access, XML-RPC usage, and admin endpoints.',
        'controls' => array(
            array(
                'control_key' => 'a01_admin_capabilities',
                'name' => 'Admin capability hardening',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_admin_capabilities',
            ),
            array(
                'control_key' => 'a01_privilege_escalation',
                'name' => 'Privilege escalation detection',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_privilege_escalation',
            ),
            array(
                'control_key' => 'a01_rest_route_permissions',
                'name' => 'REST route permission checks',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_rest_routes',
            ),
            array(
                'control_key' => 'a01_rest_sensitive_block',
                'name' => 'Block unauth REST to sensitive endpoints',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_rest_sensitive_block',
                'toggle_option_key' => 'rest_block_users_settings',
                'enforcement_callback' => 'shadowscan_owasp_toggle_rest_sensitive_block',
            ),
            array(
                'control_key' => 'a01_xmlrpc',
                'name' => 'XML-RPC exposure detection',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_xmlrpc',
                'toggle_option_key' => 'xmlrpc_enforce_disable',
                'enforcement_callback' => 'shadowscan_owasp_toggle_xmlrpc_disable',
            ),
            array(
                'control_key' => 'a01_file_mods',
                'name' => 'File editor / mods allowed',
                'risk_default' => 'low',
                'detection_callback' => 'shadowscan_owasp_check_file_mods',
            ),
        ),
    ),
    array(
        'category_id' => 'A02',
        'title' => 'Cryptographic Failures',
        'description' => 'Cryptographic storage, transport, and secret handling.',
        'controls' => array(
            array(
                'control_key' => 'a02_https_not_enforced',
                'name' => 'HTTPS enforcement',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_https_not_enforced',
            ),
            array(
                'control_key' => 'a02_insecure_cookies',
                'name' => 'Secure cookies on HTTPS',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_insecure_cookies',
            ),
            array(
                'control_key' => 'a02_weak_hashing_usage',
                'name' => 'Weak hashing usage (plugin)',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_weak_hashing',
            ),
            array(
                'control_key' => 'a02_missing_security_headers',
                'name' => 'Security headers missing',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_security_headers',
            ),
            array(
                'control_key' => 'a02_force_ssl_admin',
                'name' => 'Force SSL for admin',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_force_ssl_admin',
                'toggle_option_key' => 'force_ssl_admin',
                'enforcement_callback' => 'shadowscan_owasp_toggle_force_ssl_admin',
            ),
        ),
    ),
    array(
        'category_id' => 'A03',
        'title' => 'Injection',
        'description' => 'User input handling and query safety.',
        'controls' => array(
            array(
                'control_key' => 'a03_db_error_leak',
                'name' => 'Database error leakage',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_db_error_leak',
            ),
            array(
                'control_key' => 'a03_untrusted_input_patterns',
                'name' => 'Untrusted input patterns (plugin)',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_untrusted_input_patterns',
            ),
            array(
                'control_key' => 'a03_waf_block_signals',
                'name' => 'WAF / brute force signals',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_waf_signals',
            ),
            array(
                'control_key' => 'a03_disable_debug_display',
                'name' => 'Disable debug display',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_disable_debug_display',
                'toggle_option_key' => 'owasp_disable_debug_display',
                'enforcement_callback' => 'shadowscan_owasp_toggle_disable_debug_display',
            ),
        ),
    ),
    array(
        'category_id' => 'A04',
        'title' => 'Insecure Design',
        'description' => 'Design-level security controls and guardrails.',
        'controls' => array(
            array(
                'control_key' => 'a04_missing_rate_limits',
                'name' => 'Rate limit guardrails',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_rate_limits',
            ),
            array(
                'control_key' => 'a04_sensitive_actions_require_nonce',
                'name' => 'Admin action nonce checks',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_nonce_requirements',
            ),
            array(
                'control_key' => 'a04_break_glass_controls',
                'name' => 'Break-glass controls',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_break_glass',
            ),
            array(
                'control_key' => 'a04_enforce_sensitive_action_policy',
                'name' => 'Enforce sensitive action policy',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_sensitive_action_policy',
                'toggle_option_key' => 'owasp_enforce_sensitive_actions',
                'enforcement_callback' => 'shadowscan_owasp_toggle_sensitive_actions',
            ),
        ),
    ),
    array(
        'category_id' => 'A05',
        'title' => 'Security Misconfiguration',
        'description' => 'Misconfigurations across WordPress and server settings.',
        'controls' => array(
            array(
                'control_key' => 'a05_file_editor_enabled',
                'name' => 'File editor enabled',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_file_editor',
            ),
            array(
                'control_key' => 'a05_directory_listing_possible',
                'name' => 'Directory listing baseline',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_directory_listing',
            ),
            array(
                'control_key' => 'a05_debug_enabled',
                'name' => 'Debug flags enabled',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_debug_enabled',
            ),
            array(
                'control_key' => 'a05_exposed_version',
                'name' => 'Exposed WordPress version',
                'risk_default' => 'low',
                'detection_callback' => 'shadowscan_owasp_check_exposed_version',
            ),
            array(
                'control_key' => 'a05_open_rest_user_enum',
                'name' => 'REST user enumeration',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_rest_user_enum',
                'toggle_option_key' => 'rest_block_users_settings',
                'enforcement_callback' => 'shadowscan_owasp_toggle_rest_sensitive_block',
            ),
        ),
    ),
    array(
        'category_id' => 'A06',
        'title' => 'Vulnerable and Outdated Components',
        'description' => 'Component inventory and update posture.',
        'controls' => array(
            array(
                'control_key' => 'a06_outdated_wp_core',
                'name' => 'Outdated WordPress core',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_outdated_core',
            ),
            array(
                'control_key' => 'a06_outdated_plugins',
                'name' => 'Outdated plugins',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_outdated_plugins',
            ),
            array(
                'control_key' => 'a06_outdated_themes',
                'name' => 'Outdated themes',
                'risk_default' => 'low',
                'detection_callback' => 'shadowscan_owasp_check_outdated_themes',
            ),
            array(
                'control_key' => 'a06_auto_update_security_patches',
                'name' => 'Enable auto-updates for security patches',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_auto_updates',
                'toggle_option_key' => 'owasp_auto_update_minor',
                'enforcement_callback' => 'shadowscan_owasp_toggle_auto_updates',
            ),
        ),
    ),
    array(
        'category_id' => 'A07',
        'title' => 'Identification and Authentication Failures',
        'description' => 'Authentication flows and account protections.',
        'controls' => array(
            array(
                'control_key' => 'a07_no_mfa_detected',
                'name' => 'MFA coverage',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_mfa_detected',
            ),
            array(
                'control_key' => 'a07_weak_password_policy',
                'name' => 'Weak password policy signals',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_password_policy',
            ),
            array(
                'control_key' => 'a07_bruteforce_signals',
                'name' => 'Bruteforce signals',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_bruteforce_signals',
            ),
            array(
                'control_key' => 'a07_default_admin_username',
                'name' => 'Default admin username',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_default_admin_username',
            ),
            array(
                'control_key' => 'a07_login_rate_limit',
                'name' => 'Login rate limiting',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_login_rate_limit',
                'toggle_option_key' => 'owasp_login_rate_limit',
                'enforcement_callback' => 'shadowscan_owasp_toggle_login_rate_limit',
            ),
        ),
    ),
    array(
        'category_id' => 'A08',
        'title' => 'Software and Data Integrity Failures',
        'description' => 'Integrity of code, updates, and deployment process.',
        'controls' => array(
            array(
                'control_key' => 'a08_plugin_file_integrity_changed',
                'name' => 'Plugin file integrity',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_integrity_changes',
            ),
            array(
                'control_key' => 'a08_updates_from_untrusted_sources',
                'name' => 'Updates from untrusted sources',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_untrusted_updates',
            ),
            array(
                'control_key' => 'a08_webhook_signature_missing',
                'name' => 'Inbound signature validation',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_signature_validation',
            ),
            array(
                'control_key' => 'a08_enforce_signature_validation',
                'name' => 'Enforce signature validation',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_signature_enforcement',
                'toggle_option_key' => 'owasp_enforce_command_signing',
                'enforcement_callback' => 'shadowscan_owasp_toggle_command_signing',
            ),
        ),
    ),
    array(
        'category_id' => 'A09',
        'title' => 'Security Logging and Monitoring Failures',
        'description' => 'Event detection, logging, and monitoring coverage.',
        'controls' => array(
            array(
                'control_key' => 'a09_audit_log_disabled',
                'name' => 'Audit log pipeline health',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_audit_pipeline',
            ),
            array(
                'control_key' => 'a09_missing_admin_audit',
                'name' => 'Admin audit coverage',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_admin_audit',
            ),
            array(
                'control_key' => 'a09_no_alert_channels',
                'name' => 'Alert routing configured',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_alert_channels',
            ),
            array(
                'control_key' => 'a09_fail_closed_on_logging',
                'name' => 'Fail closed on logging loss',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_fail_closed_logging',
                'toggle_option_key' => 'owasp_fail_closed_logging',
                'enforcement_callback' => 'shadowscan_owasp_toggle_fail_closed_logging',
            ),
        ),
    ),
    array(
        'category_id' => 'A10',
        'title' => 'Server-Side Request Forgery',
        'description' => 'Server-side request protections and restrictions.',
        'controls' => array(
            array(
                'control_key' => 'a10_unrestricted_http_requests',
                'name' => 'Outbound allowlist enforcement',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_outbound_allowlist',
            ),
            array(
                'control_key' => 'a10_open_redirect_proxy_endpoints',
                'name' => 'No open proxy endpoints',
                'risk_default' => 'high',
                'detection_callback' => 'shadowscan_owasp_check_proxy_endpoints',
            ),
            array(
                'control_key' => 'a10_metadata_ip_access',
                'name' => 'Metadata IP access',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_metadata_access',
            ),
            array(
                'control_key' => 'a10_enforce_outbound_allowlist',
                'name' => 'Enforce outbound allowlist',
                'risk_default' => 'medium',
                'detection_callback' => 'shadowscan_owasp_check_outbound_enforcement',
                'toggle_option_key' => 'owasp_outbound_allowlist',
                'enforcement_callback' => 'shadowscan_owasp_toggle_outbound_allowlist',
            ),
        ),
    ),
);
