<?php
if (!defined('ABSPATH')) {
    exit;
}

function shadowscan_get_control_registry(): array {
    static $cache = null;
    if ($cache !== null) {
        return $cache;
    }
    $path = dirname(__DIR__) . '/control-registry.json';
    if (!file_exists($path)) {
        $cache = array();
        return $cache;
    }
    $raw = file_get_contents($path);
    $data = json_decode($raw, true);
    if (!is_array($data)) {
        $cache = array();
        return $cache;
    }
    $map = array();
    foreach ($data as $entry) {
        if (!is_array($entry)) {
            continue;
        }
        $key = isset($entry['control_key']) ? (string) $entry['control_key'] : '';
        if ($key === '') {
            continue;
        }
        $map[$key] = $entry;
    }
    $cache = $map;
    return $cache;
}

function shadowscan_control_key_aliases(): array {
    return array(
        'autoupdate_plugins' => 'autoupdate_plugins_detect',
        'autoupdate_plugin_detect' => 'autoupdate_plugins_detect',
        'auto_update_plugins_detect' => 'autoupdate_plugins_detect',
        'auto_update_plugin_detect' => 'autoupdate_plugins_detect',
        'wp_core_autoupdate' => 'wp_core_autoupdate_detect',
        'wp_core_auto_update_detect' => 'wp_core_autoupdate_detect',
        'wp_core_auto_updates_detect' => 'wp_core_autoupdate_detect',
        'password_policy_enforce' => 'password_policy_enforced',
        'password_policy_enabled' => 'password_policy_enforced',
    );
}

function shadowscan_normalize_control_key(string $control_key): string {
    $normalized = strtolower(trim($control_key));
    if ($normalized === '') {
        return '';
    }
    $aliases = shadowscan_control_key_aliases();
    if (isset($aliases[$normalized])) {
        return $aliases[$normalized];
    }
    return $normalized;
}

function shadowscan_is_known_control_key(string $control_key): bool {
    $registry = shadowscan_get_control_registry();
    $normalized = function_exists('shadowscan_normalize_control_key')
        ? shadowscan_normalize_control_key($control_key)
        : $control_key;
    return isset($registry[$normalized]);
}
