<?php
/**
 * SFR Directory Map - Basic Analytics Page (Free Version)
 */

if (!defined('ABSPATH')) {
    exit;
}

// Handle settings save
if (isset($_POST['sfrdm_save_analytics_settings']) && check_admin_referer('sfrdm_analytics_settings', 'sfrdm_analytics_nonce')) {
    $enable_analytics = isset($_POST['sfrdm_enable_analytics']) ? 1 : 0;
    update_option('sfrdm_enable_analytics', $enable_analytics);
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Settings saved!', 'sfr-directory-map') . '</p></div>';
}

// Handle clear stats
if (isset($_POST['sfrdm_clear_analytics']) && check_admin_referer('sfrdm_clear_analytics', 'sfrdm_clear_nonce')) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sfrdm_search_analytics';
    $wpdb->query("TRUNCATE TABLE $table_name"); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Analytics data cleared!', 'sfr-directory-map') . '</p></div>';
}

$analytics_enabled = get_option('sfrdm_enable_analytics', 1);
?>

<div class="wrap">
    <h1><?php esc_html_e('Map Analytics', 'sfr-directory-map'); ?></h1>
    
    <div style="max-width: 1200px;">
        
        <!-- Settings -->
        <div style="background: #fff; padding: 20px; margin: 20px 0; border-left: 4px solid #0073aa; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('Analytics Settings', 'sfr-directory-map'); ?></h2>
            
            <form method="post" action="">
                <?php wp_nonce_field('sfrdm_analytics_settings', 'sfrdm_analytics_nonce'); ?>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('Enable Search Analytics', 'sfr-directory-map'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="sfrdm_enable_analytics" value="1" <?php checked($analytics_enabled, 1); ?> />
                                <?php esc_html_e('Collect anonymous search statistics', 'sfr-directory-map'); ?>
                            </label>
                            <p class="description">
                                <?php esc_html_e('Track what users search for on your maps. No personal data is collected.', 'sfr-directory-map'); ?>
                            </p>
                        </td>
                    </tr>
                </table>
                
                <button type="submit" name="sfrdm_save_analytics_settings" class="button button-primary">
                    <?php esc_html_e('Save Settings', 'sfr-directory-map'); ?>
                </button>
            </form>
            
            <?php if ($analytics_enabled): ?>
            <hr style="margin: 20px 0;">
            <form method="post" action="" onsubmit="return confirm('<?php esc_attr_e('Are you sure you want to delete all analytics data? This cannot be undone.', 'sfr-directory-map'); ?>');">
                <?php wp_nonce_field('sfrdm_clear_analytics', 'sfrdm_clear_nonce'); ?>
                <button type="submit" name="sfrdm_clear_analytics" class="button button-secondary">
                    <?php esc_html_e('Clear All Analytics Data', 'sfr-directory-map'); ?>
                </button>
                <p class="description" style="margin-top: 10px;">
                    <?php esc_html_e('Permanently delete all collected search statistics.', 'sfr-directory-map'); ?>
                </p>
            </form>
            <?php endif; ?>
        </div>
        
        <?php if ($analytics_enabled): ?>
        <!-- Stats -->
        <div style="background: #fff; padding: 20px; margin: 20px 0; border-left: 4px solid #0073aa; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('Search Statistics', 'sfr-directory-map'); ?></h2>
            
            <?php
            global $wpdb;
            $table_name = $wpdb->prefix . 'sfrdm_search_analytics';
            $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'") === $table_name; // phpcs:ignore WordPress.DB.DirectDatabaseQuery
            
            if ($table_exists):
                $total_searches = (int) $wpdb->get_var("SELECT COUNT(*) FROM $table_name"); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
                $searches_with_results = (int) $wpdb->get_var("SELECT COUNT(*) FROM $table_name WHERE results_count > 0"); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
                $success_rate = $total_searches > 0 ? ($searches_with_results / $total_searches) * 100 : 0;
                $searches_today = (int) $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE DATE(timestamp) = %s", current_time('Y-m-d'))); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
                $searches_7days = (int) $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE timestamp >= DATE_SUB(%s, INTERVAL 7 DAY)", current_time('mysql'))); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
                $unique_searches_7days = (int) $wpdb->get_var($wpdb->prepare("SELECT COUNT(DISTINCT search_term) FROM $table_name WHERE search_term != '' AND timestamp >= DATE_SUB(%s, INTERVAL 7 DAY)", current_time('mysql'))); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
                $top_searches = $wpdb->get_results("SELECT search_term, COUNT(*) as search_count, AVG(results_count) as avg_results FROM $table_name WHERE search_term != '' GROUP BY search_term ORDER BY search_count DESC LIMIT 10", ARRAY_A); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
                ?>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 15px; margin: 20px 0;">
                    <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: center; border-left: 4px solid #0073aa;">
                        <div style="font-size: 2em; font-weight: bold; color: #0073aa; margin-bottom: 5px;">
                            <?php echo esc_html(number_format($total_searches)); ?>
                        </div>
                        <div style="color: #666; font-size: 14px;"><?php esc_html_e('Total Searches', 'sfr-directory-map'); ?></div>
                    </div>
                    <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: center; border-left: 4px solid #46b450;">
                        <div style="font-size: 2em; font-weight: bold; color: #46b450; margin-bottom: 5px;">
                            <?php echo esc_html(number_format($searches_with_results)); ?>
                        </div>
                        <div style="color: #666; font-size: 14px;"><?php esc_html_e('Searches with Results', 'sfr-directory-map'); ?></div>
                    </div>
                    <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: center; border-left: 4px solid #826eb4;">
                        <div style="font-size: 2em; font-weight: bold; color: #826eb4; margin-bottom: 5px;">
                            <?php echo esc_html(number_format($success_rate, 1)); ?>%
                        </div>
                        <div style="color: #666; font-size: 14px;"><?php esc_html_e('Success Rate', 'sfr-directory-map'); ?></div>
                    </div>
                    <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: center; border-left: 4px solid #00a0d2;">
                        <div style="font-size: 2em; font-weight: bold; color: #00a0d2; margin-bottom: 5px;">
                            <?php echo esc_html(number_format($searches_today)); ?>
                        </div>
                        <div style="color: #666; font-size: 14px;"><?php esc_html_e('Searches Today', 'sfr-directory-map'); ?></div>
                    </div>
                    <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: center; border-left: 4px solid #e35950;">
                        <div style="font-size: 2em; font-weight: bold; color: #e35950; margin-bottom: 5px;">
                            <?php echo esc_html(number_format($searches_7days)); ?>
                        </div>
                        <div style="color: #666; font-size: 14px;"><?php esc_html_e('Searches Last 7 Days', 'sfr-directory-map'); ?></div>
                    </div>
                    <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: center; border-left: 4px solid #f18500;">
                        <div style="font-size: 2em; font-weight: bold; color: #f18500; margin-bottom: 5px;">
                            <?php echo esc_html(number_format($unique_searches_7days)); ?>
                        </div>
                        <div style="color: #666; font-size: 14px;"><?php esc_html_e('Unique Searches (7d)', 'sfr-directory-map'); ?></div>
                    </div>
                </div>
                
                <?php if ($top_searches && $total_searches > 0): ?>
                <div style="margin-top: 30px;">
                    <h3><?php esc_html_e('Top 10 Search Terms', 'sfr-directory-map'); ?></h3>
                    <table class="wp-list-table widefat fixed striped">
                        <thead>
                            <tr>
                                <th style="width: 50%;"><?php esc_html_e('Search Term', 'sfr-directory-map'); ?></th>
                                <th style="width: 25%;"><?php esc_html_e('Times Searched', 'sfr-directory-map'); ?></th>
                                <th style="width: 25%;"><?php esc_html_e('Avg. Results', 'sfr-directory-map'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($top_searches as $search): ?>
                            <tr>
                                <td><strong><?php echo esc_html($search['search_term']); ?></strong></td>
                                <td><?php echo esc_html(number_format((int) $search['search_count'])); ?></td>
                                <td><?php echo esc_html(number_format((float) $search['avg_results'], 1)); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php elseif ($total_searches === 0): ?>
                <p><?php esc_html_e('No analytics data yet. Analytics will be collected as users search your maps.', 'sfr-directory-map'); ?></p>
                <?php endif; ?>
                
            <?php else: ?>
                <p><?php esc_html_e('Analytics table not found. It will be created automatically.', 'sfr-directory-map'); ?></p>
            <?php endif; ?>
        </div>
        <?php else: ?>
        <div class="notice notice-info inline" style="margin: 20px 0;">
            <p><?php esc_html_e('Analytics are currently disabled. Enable them above to start collecting search statistics.', 'sfr-directory-map'); ?></p>
        </div>
        <?php endif; ?>
        
        <div class="notice notice-info inline" style="margin: 20px 0;">
            <p>
                <strong><?php esc_html_e('About Analytics', 'sfr-directory-map'); ?></strong><br>
                <?php esc_html_e('These statistics show how users are searching your maps. Data is collected anonymously.', 'sfr-directory-map'); ?>
            </p>
        </div>
        
    </div>
</div>
