/**
 * Admin Settings Page JavaScript
 * SFR Directory Map
 */

jQuery(document).ready(function($) {
    // Handle reset colour buttons
    $('.udm-reset-color').on('click', function() {
        var targetId = $(this).data('target');
        var $colorPicker = $('#' + targetId);
        var defaultColor = $colorPicker.data('default');
        $colorPicker.val(defaultColor);
        
        // Update preview
        var $preview = $colorPicker.siblings('.udm-pin-preview');
        $preview.css('background-color', defaultColor);
    });
    
    // Handle colour picker changes
    $('.udm-color-picker').on('change', function() {
        var $preview = $(this).siblings('.udm-pin-preview');
        $preview.css('background-color', $(this).val());
    });
    
    // Handle reset icon buttons
    $('.udm-reset-icon').on('click', function() {
        var targetId = $(this).data('target');
        var $iconInput = $('#' + targetId);
        var defaultIcon = $iconInput.data('default');
        $iconInput.val(defaultIcon);
        
        // Update preview
        var $preview = $iconInput.siblings('.udm-pin-icon-preview');
        $preview.text(defaultIcon);
    });
    
    // Handle icon input changes
    $('.udm-icon-picker').on('input', function() {
        var $preview = $(this).siblings('.udm-pin-icon-preview');
        $preview.text($(this).val());
    });
    
    // Handle icon suggestions
    $('.udm-icon-suggestion').on('click', function() {
        var icon = $(this).data('icon');
        var $activeInput = $('.udm-icon-picker:focus');
        if ($activeInput.length) {
            $activeInput.val(icon);
            var $preview = $activeInput.siblings('.udm-pin-icon-preview');
            $preview.text(icon);
        }
    });
});

// Map preview functionality
document.addEventListener('DOMContentLoaded', function() {
    console.log('UDM: DOM loaded, starting map preview initialization');
    
    var mapPreviewContainer = document.getElementById('udm-map-preview-container');
    if (!mapPreviewContainer) {
        console.log('UDM: No map preview container found');
        return;
    }
    
    console.log('UDM: Map preview container found, waiting for scripts...');
    
    function waitForScripts() {
        if (typeof L === 'undefined' || typeof L.markerClusterGroup === 'undefined') {
            console.log('UDM: Waiting for Leaflet/MarkerCluster...');
            setTimeout(waitForScripts, 100);
            return;
        }
        
        console.log('UDM: Leaflet loaded, initializing preview map');
        initPreviewMap();
    }
    
    function initPreviewMap() {
        try {
            console.log('UDM: Creating preview map...');
            
            var mapElement = document.createElement('div');
            mapElement.id = 'udm-preview-map';
            mapElement.style.height = '400px';
            mapElement.style.width = '100%';
            mapElement.style.marginTop = '20px';
            mapElement.style.border = '2px solid #ddd';
            mapElement.style.borderRadius = '8px';
            
            mapPreviewContainer.appendChild(mapElement);
            
            var map = L.map('udm-preview-map').setView([54.5, -2.0], 6);
            
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '© OpenStreetMap contributors',
                maxZoom: 19
            }).addTo(map);
            
            console.log('UDM: Preview map created successfully');
            
            // Get plugin URL from sfrdmSettings or calculate from script location
            var pluginUrl = (typeof sfrdmSettings !== 'undefined' && sfrdmSettings.plugin_url) 
                ? sfrdmSettings.plugin_url 
                : '';
            
            // If sfrdmSettings not available, try to get from current script location
            if (!pluginUrl) {
                var scripts = document.getElementsByTagName('script');
                for (var i = 0; i < scripts.length; i++) {
                    var src = scripts[i].src;
                    if (src && src.indexOf('admin-settings.js') !== -1) {
                        pluginUrl = src.substring(0, src.indexOf('/assets/'));
                        break;
                    }
                }
            }
            
            var markerIcon = L.icon({
                iconUrl: pluginUrl + 'assets/vendor/leaflet/images/marker-icon.png',
                iconRetinaUrl: pluginUrl + 'assets/vendor/leaflet/images/marker-icon-2x.png',
                shadowUrl: pluginUrl + 'assets/vendor/leaflet/images/marker-shadow.png',
                iconSize: [25, 41],
                iconAnchor: [12, 41],
                popupAnchor: [1, -34],
                shadowSize: [41, 41]
            });
            
            L.marker([54.5, -2.0], {icon: markerIcon})
                .addTo(map)
                .bindPopup('<b>Example Listing</b><br>Your listings will appear here');
            
            console.log('UDM: Example marker added');
            
        } catch (error) {
            console.error('UDM: Error initializing preview map:', error);
        }
    }
    
    waitForScripts();
});









