/**
 * SFR Directory Map - Admin Meta Box JavaScript
 */
jQuery(document).ready(function($) {
    // Handle reset colour buttons
    $('.udm-reset-color, .sfrdm-reset-color').on('click', function() {
        var targetId = $(this).data('target');
        var $colorPicker = $('#' + targetId);
        var defaultColor = $colorPicker.data('default');
        $colorPicker.val(defaultColor);
        
        // Update preview
        var $preview = $colorPicker.siblings('.udm-pin-preview, .sfrdm-pin-preview');
        $preview.css('background-color', defaultColor);
    });
    
    // Handle colour picker changes
    $('.udm-color-picker, .sfrdm-color-picker').on('change', function() {
        var $preview = $(this).siblings('.udm-pin-preview, .sfrdm-pin-preview');
        $preview.css('background-color', $(this).val());
    });
    
    // Handle reset icon buttons
    $('.udm-reset-icon, .sfrdm-reset-icon').on('click', function() {
        var targetId = $(this).data('target');
        var $iconInput = $('#' + targetId);
        var defaultIcon = $iconInput.data('default');
        $iconInput.val(defaultIcon);
        
        // Update preview
        var $preview = $iconInput.siblings('.udm-pin-icon-preview, .sfrdm-pin-icon-preview');
        $preview.text(defaultIcon);
    });
    
    // Handle icon input changes
    $('.udm-icon-picker, .sfrdm-icon-picker').on('input', function() {
        var $preview = $(this).siblings('.udm-pin-icon-preview, .sfrdm-pin-icon-preview');
        $preview.text($(this).val());
    });
    
    // Handle icon suggestions
    $('.udm-icon-suggestion, .sfrdm-icon-suggestion').on('click', function() {
        var icon = $(this).data('icon');
        var $activeInput = $('.udm-icon-picker:focus, .sfrdm-icon-picker:focus');
        if ($activeInput.length) {
            $activeInput.val(icon);
            var $preview = $activeInput.siblings('.udm-pin-icon-preview, .sfrdm-pin-icon-preview');
            $preview.text(icon);
        }
    });
    
    // Handle auto-fit bounds checkbox
    $('#sfrdm_auto_fit_bounds').on('change', function() {
        if ($(this).is(':checked')) {
            // When enabled, zoom/center become fallbacks only
            console.log('Auto-fit enabled - map will adjust to show all pins');
        } else {
            console.log('Auto-fit disabled - using fixed zoom/center');
        }
    });
    
    // Map preview initialization
    var adminPreviewMap = null;
    var adminPreviewMarkers = [];
    
    function initAdminMapPreview() {
        var previewContainer = document.getElementById('udm-admin-preview');
        if (!previewContainer || typeof L === 'undefined') {
            return;
        }
        
        // Get initial settings
        var lat = parseFloat($('#sfrdm_default_lat').val()) || 54.5;
        var lng = parseFloat($('#sfrdm_default_lng').val()) || -2.0;
        var zoom = parseInt($('#sfrdm_default_zoom').val()) || 6;
        var style = $('#sfrdm_map_style').val() || 'openstreetmap';
        
        // Initialize map
        adminPreviewMap = L.map('udm-admin-preview').setView([lat, lng], zoom);
        
        // Add tile layer based on style
        updateMapStyle(style);
        
        // Add some sample markers
        addSampleMarkers();
    }
    
    function updateMapStyle(style) {
        if (!adminPreviewMap) return;
        
        // Remove existing tile layers
        adminPreviewMap.eachLayer(function(layer) {
            if (layer instanceof L.TileLayer) {
                adminPreviewMap.removeLayer(layer);
            }
        });
        
        // Map style URLs
        var tileUrls = {
            'openstreetmap': 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
            'cartodb_positron': 'https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png',
            'cartodb_dark': 'https://{s}.basemaps.cartocdn.com/dark_all/{z}/{x}/{y}.png'
        };
        
        var tileUrl = tileUrls[style] || tileUrls['openstreetmap'];
        L.tileLayer(tileUrl, {
            attribution: '© OpenStreetMap contributors'
        }).addTo(adminPreviewMap);
    }
    
    function addSampleMarkers() {
        if (!adminPreviewMap) return;
        
        // Clear existing markers
        adminPreviewMarkers.forEach(function(marker) {
            adminPreviewMap.removeLayer(marker);
        });
        adminPreviewMarkers = [];
        
        // Add sample markers near the center
        var center = adminPreviewMap.getCenter();
        var sampleLocations = [
            [center.lat + 0.5, center.lng + 0.5],
            [center.lat - 0.5, center.lng - 0.5],
            [center.lat + 0.5, center.lng - 0.5]
        ];
        
        sampleLocations.forEach(function(coords) {
            var marker = L.marker(coords).addTo(adminPreviewMap);
            adminPreviewMarkers.push(marker);
        });
    }
    
    function updateMapPreview() {
        if (!adminPreviewMap) return;
        
        var lat = parseFloat($('#sfrdm_default_lat').val()) || 54.5;
        var lng = parseFloat($('#sfrdm_default_lng').val()) || -2.0;
        var zoom = parseInt($('#sfrdm_default_zoom').val()) || 6;
        var style = $('#sfrdm_map_style').val() || 'openstreetmap';
        
        adminPreviewMap.setView([lat, lng], zoom);
        updateMapStyle(style);
        addSampleMarkers();
    }
    
    // Initialize preview map when Leaflet is ready
    if (typeof L !== 'undefined') {
        setTimeout(initAdminMapPreview, 100);
    }
    
    // Attach change handlers for map settings
    $('#sfrdm_default_lat, #sfrdm_default_lng, #sfrdm_default_zoom, #sfrdm_map_style').on('change', updateMapPreview);
});

