<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap semfe-admin-page">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<nav class="nav-tab-wrapper wp-clearfix" role="tablist" aria-label="<?php esc_attr_e( 'Settings Manager Tabs', 'settings-manager-for-elementor' ); ?>">
		<a href="#export" class="nav-tab nav-tab-active" data-tab="export" role="tab" aria-selected="true" aria-controls="tabpanel-export" id="tab-export">
			<?php esc_html_e( 'Export', 'settings-manager-for-elementor' ); ?>
		</a>
		<a href="#import" class="nav-tab" data-tab="import" role="tab" aria-selected="false" aria-controls="tabpanel-import" id="tab-import">
			<?php esc_html_e( 'Import', 'settings-manager-for-elementor' ); ?>
		</a>
		<a href="#help" class="nav-tab" data-tab="help" role="tab" aria-selected="false" aria-controls="tabpanel-help" id="tab-help">
			<?php esc_html_e( 'Help', 'settings-manager-for-elementor' ); ?>
		</a>
	</nav>

	<div class="semfe-admin-container">

		<!-- Export Tab Content -->
		<div class="semfe-tab-content active" data-tab="export" role="tabpanel" id="tabpanel-export" aria-labelledby="tab-export">
			<div class="semfe-card">
				<h2><?php esc_html_e( 'Export Settings', 'settings-manager-for-elementor' ); ?></h2>

				<p><?php esc_html_e( 'Export Elementor settings to JSON file. Select which categories to include:', 'settings-manager-for-elementor' ); ?></p>

				<div class="semfe-category-selection" id="export-categories">
					<div class="semfe-select-all">
						<label>
							<input type="checkbox" id="export-select-all" checked><strong><?php esc_html_e( 'Select All / Deselect All', 'settings-manager-for-elementor' ); ?></strong>
						</label>
					</div>

					<div id="export-category-tree">
						<?php $this->render_category_tree(); ?>
					</div>
				</div>

				<div class="semfe-filename-option">
					<label for="export-filename"><?php esc_html_e( 'Export Filename', 'settings-manager-for-elementor' ); ?></label>
					<div class="semfe-filename-input-wrapper">
						<input type="text"
							   id="export-filename"
							   placeholder="elementor-settings-YYYYMMDD-HHMM"
						>
						<span class="semfe-filename-extension">.json</span>
					</div>
					<p class="description"><?php esc_html_e( 'Leave empty for default timestamp-based name', 'settings-manager-for-elementor' ); ?></p>
				</div>

				<div class="semfe-description-option">
					<label for="export-description"><?php esc_html_e( 'Description (Optional)', 'settings-manager-for-elementor' ); ?></label>
					<textarea id="export-description" maxlength="1000" rows="3" placeholder="<?php esc_attr_e( 'Add a note about this export...', 'settings-manager-for-elementor' ); ?>"></textarea>
					<span class="semfe-char-counter">0 / 1000 <?php esc_html_e( 'characters', 'settings-manager-for-elementor' ); ?></span>
				</div>

				<div class="semfe-actions">
					<button type="button" class="button button-primary button-large" id="export-btn">
						<?php esc_html_e( 'Export to JSON', 'settings-manager-for-elementor' ); ?>
					</button>
				</div>

				<div id="export-status" class="semfe-status"></div>
			</div>
		</div>

		<!-- Import Tab Content -->
		<div class="semfe-tab-content" data-tab="import" role="tabpanel" id="tabpanel-import" aria-labelledby="tab-import">
			<div class="semfe-card">
				<h2><?php esc_html_e( 'Import Settings', 'settings-manager-for-elementor' ); ?></h2>

				<p><?php esc_html_e( 'Import Elementor settings from JSON file:', 'settings-manager-for-elementor' ); ?></p>

				<div class="semfe-file-upload">
					<input type="file" id="import-file-input" accept=".json" style="display:none;">
					<button type="button" class="button" id="choose-file-btn">
						<?php esc_html_e( 'Choose JSON File', 'settings-manager-for-elementor' ); ?>
					</button>
					<span id="file-name"></span>
				</div>

				<!-- Import Preview -->
				<div id="import-preview" class="semfe-import-preview" style="display:none;">
					<h3><?php esc_html_e( 'Import Preview', 'settings-manager-for-elementor' ); ?></h3>
					<div id="import-preview-content"></div>

					<h4><?php esc_html_e( 'Select Categories to Import:', 'settings-manager-for-elementor' ); ?></h4>

					<div class="semfe-category-selection" id="import-categories">
						<div class="semfe-select-all">
							<label>
								<input type="checkbox" id="import-select-all" checked><strong><?php esc_html_e( 'Select All / Deselect All', 'settings-manager-for-elementor' ); ?></strong>
							</label>
						</div>

						<div id="import-category-tree"></div>
					</div>

					<h4><?php esc_html_e( 'Import Strategy', 'settings-manager-for-elementor' ); ?> <span class="description"><?php esc_html_e( '(for Global Colors & Global Fonts):', 'settings-manager-for-elementor' ); ?></span></h4>
					<div class="semfe-strategy">
						<label>
							<span><input type="radio" name="import-strategy" value="merge" checked>&ZeroWidthSpace;</span>
							<div>
							<strong><?php esc_html_e( 'Merge with existing', 'settings-manager-for-elementor' ); ?></strong> <?php esc_html_e( '(Recommended)', 'settings-manager-for-elementor' ); ?>
							<br><span class="description"><?php esc_html_e( 'Add imported colors/typography, update matching ones by ID, keep others', 'settings-manager-for-elementor' ); ?></span>
							</div>
						</label>
						<br>
						<label>
							<span><input type="radio" name="import-strategy" value="replace">&ZeroWidthSpace;</span>
							<div>
							<strong><?php esc_html_e( 'Replace existing', 'settings-manager-for-elementor' ); ?></strong>
							<br><span class="description"><?php esc_html_e( 'Remove ALL current colors/typography, use only imported ones', 'settings-manager-for-elementor' ); ?></span>
							</div>
						</label>
					</div>

					<?php if ( is_multisite() && current_user_can( 'manage_network' ) ) : ?>
						<?php // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable, not global ?>
						<?php $is_premium = semfe_fs()->can_use_premium_code(); ?>
						<details class="semfe-network-sites <?php echo ! $is_premium ? 'semfe-pro-locked' : ''; ?>" id="import-network-sites">
							<summary>
								<span class="dashicons dashicons-arrow-down-alt2 semfe-dropdown-icon"></span>
								<?php esc_html_e( 'Also Import to Network Sites', 'settings-manager-for-elementor' ); ?>
								<?php if ( ! $is_premium ) : ?>
									<span class="semfe-pro-badge">PRO</span>
								<?php endif; ?>
							</summary>
							<div id="import-sites-list" class="semfe-sites-list" data-disabled="<?php echo ! $is_premium ? 'true' : 'false'; ?>">
								<!-- Sites loaded via JavaScript -->
								<div class="semfe-sites-loading">
									<span class="dashicons dashicons-update spin"></span>
									<?php esc_html_e( 'Loading network sites...', 'settings-manager-for-elementor' ); ?>
								</div>
							</div>
						</details>
					<?php endif; ?>

					<div class="semfe-actions">
						<button type="button" class="button button-primary button-large" id="import-btn">
							<?php if ( is_multisite() && current_user_can( 'manage_network' ) ) : ?>
								<?php esc_html_e( 'Import to This Site', 'settings-manager-for-elementor' ); ?>
							<?php else : ?>
								<?php esc_html_e( 'Import Settings', 'settings-manager-for-elementor' ); ?>
							<?php endif; ?>
						</button>
						<button type="button" class="button" id="cancel-import-btn">
							<?php esc_html_e( 'Cancel', 'settings-manager-for-elementor' ); ?>
						</button>
					</div>
				</div>

				<div id="import-status" class="semfe-status"></div>
			</div>
		</div>

		<!-- Help Tab Content -->
		<div class="semfe-tab-content" data-tab="help" role="tabpanel" id="tabpanel-help" aria-labelledby="tab-help">
			<div class="semfe-card semfe-help">
				<h2><span class="dashicons dashicons-info"></span> <?php esc_html_e( 'Help & Information', 'settings-manager-for-elementor' ); ?></h2>

				<h3><?php esc_html_e( 'What does this plugin do?', 'settings-manager-for-elementor' ); ?></h3>
				<p><?php esc_html_e( 'This plugin allows you to export and import Elementor settings with granular control. You can choose exactly which settings to export/import:', 'settings-manager-for-elementor' ); ?></p>

				<ul>
					<li><strong><?php esc_html_e( 'Design System:', 'settings-manager-for-elementor' ); ?></strong> <?php esc_html_e( 'Global colors and typography', 'settings-manager-for-elementor' ); ?></li>
					<li><strong><?php esc_html_e( 'Theme Style:', 'settings-manager-for-elementor' ); ?></strong> <?php esc_html_e( 'Base styling for buttons, forms, images, etc.', 'settings-manager-for-elementor' ); ?></li>
					<li><strong><?php esc_html_e( 'Settings:', 'settings-manager-for-elementor' ); ?></strong> <?php esc_html_e( 'Layout, background, lightbox, custom CSS', 'settings-manager-for-elementor' ); ?></li>
					<li><strong><?php esc_html_e( 'Backend Settings:', 'settings-manager-for-elementor' ); ?></strong> <?php esc_html_e( 'General, integrations, performance, features and experiments', 'settings-manager-for-elementor' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Use Cases:', 'settings-manager-for-elementor' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'Transfer settings from development to production site', 'settings-manager-for-elementor' ); ?></li>
					<li><?php esc_html_e( 'Create templates for new client projects', 'settings-manager-for-elementor' ); ?></li>
					<li><?php esc_html_e( 'Backup your Elementor configuration', 'settings-manager-for-elementor' ); ?></li>
					<li><?php esc_html_e( 'Share settings across multiple sites', 'settings-manager-for-elementor' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Important Notes:', 'settings-manager-for-elementor' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'Most categories are selected by default for export/import', 'settings-manager-for-elementor' ); ?></li>
					<li><?php esc_html_e( 'Media categories (logo, favicon, background image, preloader media) are NOT selected by default as they typically require manual setup per site', 'settings-manager-for-elementor' ); ?></li>
					<li><?php esc_html_e( 'Integrations (API keys) are NOT selected by default for security - never share export files containing API keys publicly', 'settings-manager-for-elementor' ); ?></li>
					<li><?php esc_html_e( 'Import strategy (Merge/Replace) only affects Global Colors and Global Fonts', 'settings-manager-for-elementor' ); ?></li>
					<li><?php esc_html_e( 'Settings are automatically backed up before import (30-day retention), but we recommend a full site backup too', 'settings-manager-for-elementor' ); ?></li>
				</ul>
			</div>
		</div>

	</div><!-- .semfe-admin-container -->

	<?php if ( semfe_fs()->is_not_paying() ) : ?>
	<!-- PRO CTA Box (always visible, outside tabs) -->
	<div class="semfe-card semfe-cta-box">
		<h2><?php esc_html_e( 'Unlock PRO Features', 'settings-manager-for-elementor' ); ?></h2>
		<ul class="semfe-cta-features">
			<li><?php esc_html_e( 'Page Transitions export/import', 'settings-manager-for-elementor' ); ?></li>
			<li><?php esc_html_e( 'Preloader export/import', 'settings-manager-for-elementor' ); ?></li>
			<li><?php esc_html_e( 'Custom CSS export/import', 'settings-manager-for-elementor' ); ?></li>
			<li><?php esc_html_e( 'Import to Multiple Network Sites', 'settings-manager-for-elementor' ); ?></li>
			<li><?php esc_html_e( 'WP-CLI Commands', 'settings-manager-for-elementor' ); ?></li>
			<li><?php esc_html_e( 'Priority Support', 'settings-manager-for-elementor' ); ?></li>
			<li><?php esc_html_e( 'Lifetime deal available', 'settings-manager-for-elementor' ); ?></li>
			<li><?php esc_html_e( '14 Days Money Back Guarantee', 'settings-manager-for-elementor' ); ?></li>
		</ul>
		<a href="<?php echo esc_url( semfe_fs()->get_upgrade_url() ); ?>" class="button button-primary button-large semfe-cta-button">
			<?php esc_html_e( 'Unlock Pro', 'settings-manager-for-elementor' ); ?>
		</a>
	</div>
	<?php endif; ?>

</div><!-- .wrap -->
