<?php

/**
 * Plugin Name: Settings Manager for Elementor
 * Description: Granular Elementor settings export and import.
 * Version: 1.0.3
 * Author: Coddium
 * Author URI: https://coddium.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires Plugins: elementor 
 * Elementor tested up to: 3.35.5
 * Text Domain: settings-manager-for-elementor
 * Requires at least: 6.0
 * Requires PHP: 7.4
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
// Define plugin constants
define( 'SEMFE_VERSION', '1.0.3' );
define( 'SEMFE_FILE', __FILE__ );
define( 'SEMFE_PATH', plugin_dir_path( __FILE__ ) );
define( 'SEMFE_URL', plugin_dir_url( __FILE__ ) );
if ( function_exists( 'semfe_fs' ) ) {
    semfe_fs()->set_basename( false, __FILE__ );
} else {
    /**
     * DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE
     * `function_exists` CALL ABOVE TO PROPERLY WORK.
     */
    if ( !function_exists( 'semfe_fs' ) ) {
        // Create a helper function for easy SDK access.
        function semfe_fs() {
            global $semfe_fs;
            if ( !isset( $semfe_fs ) ) {
                // Activate multisite network integration.
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedConstantFound -- Freemius SDK required constant name
                if ( !defined( 'WP_FS__PRODUCT_22174_MULTISITE' ) ) {
                    define( 'WP_FS__PRODUCT_22174_MULTISITE', true );
                }
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
                $semfe_fs = fs_dynamic_init( array(
                    'id'               => '22174',
                    'slug'             => 'settings-manager-for-elementor',
                    'premium_slug'     => 'settings-manager-for-elementor-pro',
                    'type'             => 'plugin',
                    'public_key'       => 'pk_98c2e146fc56e501b93997aed1e55',
                    'is_premium'       => false,
                    'is_org_compliant' => true,
                    'premium_suffix'   => 'Professional',
                    'has_addons'       => false,
                    'has_paid_plans'   => true,
                    'has_affiliation'  => 'all',
                    'menu'             => array(
                        'slug'    => 'settings-manager-for-elementor',
                        'support' => false,
                    ),
                    'is_live'          => true,
                ) );
            }
            return $semfe_fs;
        }

        // Init Freemius.
        semfe_fs();
        // Signal that SDK was initiated.
        do_action( 'semfe_fs_loaded' );
    }
    // Check if Elementor is active
    add_action( 'plugins_loaded', 'semfe_init' );
    function semfe_init() {
        // Check if Elementor is installed and activated
        if ( !did_action( 'elementor/loaded' ) ) {
            add_action( 'admin_notices', 'semfe_fail_load' );
            return;
        }
        // Check minimum Elementor version (3.23.0+ required for top bar API)
        if ( !version_compare( ELEMENTOR_VERSION, '3.23.0', '>=' ) ) {
            add_action( 'admin_notices', 'semfe_fail_load_version' );
            return;
        }
        // Require the main plugin class
        require_once SEMFE_PATH . 'includes/class-plugin.php';
        // Initialize the plugin
        \SEMFE\Plugin::instance();
    }

    /**
     * Admin notice if Elementor is not active
     */
    function semfe_fail_load() {
        $message = sprintf( 
            /* translators: 1: Plugin name 2: Elementor */
            esc_html__( '%1$s requires %2$s to be installed and activated.', 'settings-manager-for-elementor' ),
            '<strong>' . esc_html__( 'Settings Manager for Elementor', 'settings-manager-for-elementor' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'settings-manager-for-elementor' ) . '</strong>'
         );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', wp_kses_post( $message ) );
    }

    /**
     * Admin notice if Elementor version is not compatible
     */
    function semfe_fail_load_version() {
        $message = sprintf(
            /* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
            esc_html__( '%1$s requires %2$s version %3$s or greater.', 'settings-manager-for-elementor' ),
            '<strong>' . esc_html__( 'Settings Manager for Elementor', 'settings-manager-for-elementor' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'settings-manager-for-elementor' ) . '</strong>',
            '3.23.0'
        );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', wp_kses_post( $message ) );
    }

}