# Translation Files

This directory contains translation files for the Settings Manager for Elementor plugin.

## Generating Translation Template (POT file)

To generate the POT file that contains all translatable strings from both PHP and JavaScript files, you need WP-CLI with the i18n-command package installed.

### Prerequisites

1. **Install WP-CLI**: https://wp-cli.org/#installing
2. **Install i18n-command** (usually included with WP-CLI):
   ```bash
   wp package install wp-cli/i18n-command
   ```

### Generate POT File

From the plugin root directory, run:

```bash
wp i18n make-pot . languages/settings-manager-for-elementor.pot --domain=settings-manager-for-elementor
```

This will scan all PHP and JavaScript files and extract translatable strings into `settings-manager-for-elementor.pot`.

## Creating Translations

### Option 1: Using Poedit (Recommended for Translators)

1. Download and install [Poedit](https://poedit.net/)
2. Open `settings-manager-for-elementor.pot` in Poedit
3. Click "Create New Translation" and select your language
4. Translate the strings
5. Save the file (Poedit will create both `.po` and `.mo` files automatically)
   - Example: `settings-manager-for-elementor-es_ES.po` and `settings-manager-for-elementor-es_ES.mo`

### Option 2: Manual Creation

1. Copy `settings-manager-for-elementor.pot` to `settings-manager-for-elementor-{locale}.po`
   - Example: `settings-manager-for-elementor-fr_FR.po` for French
2. Edit the `.po` file with any text editor or translation tool
3. Generate the binary `.mo` file:
   ```bash
   msgfmt settings-manager-for-elementor-fr_FR.po -o settings-manager-for-elementor-fr_FR.mo
   ```

## JavaScript Translations

JavaScript translations require additional JSON files. After creating your `.po` and `.mo` files, generate the JSON files:

```bash
wp i18n make-json languages/ --no-purge
```

This will create JSON files for each JavaScript file and locale:
- `settings-manager-for-elementor-{locale}-semfe-admin.json` (for admin-page.js)
- `settings-manager-for-elementor-{locale}-semfe-editor.json` (for editor-panel.js)

**Important**: The `--no-purge` flag keeps JavaScript strings in the `.po` file, so they're available for both PHP and JS translations.

## File Naming Convention

Translation files must follow this naming pattern:

### PHP Translations
- POT (template): `settings-manager-for-elementor.pot`
- PO (source): `settings-manager-for-elementor-{locale}.po`
- MO (binary): `settings-manager-for-elementor-{locale}.mo`

### JavaScript Translations
- JSON: `settings-manager-for-elementor-{locale}-{script-handle}.json`

Where:
- `{locale}` is the WordPress locale code (e.g., `es_ES`, `fr_FR`, `de_DE`)
- `{script-handle}` is the script handle used in `wp_enqueue_script()` (`semfe-admin` or `semfe-editor`)

## Translation Workflow

### For Plugin Developers

1. Update code with new translatable strings
2. Generate POT file: `wp i18n make-pot . languages/settings-manager-for-elementor.pot`
3. Distribute POT file to translators
4. Receive translated PO files back
5. Generate MO and JSON files:
   ```bash
   msgfmt languages/settings-manager-for-elementor-es_ES.po -o languages/settings-manager-for-elementor-es_ES.mo
   wp i18n make-json languages/ --no-purge
   ```
6. Commit all translation files to repository

### For Translators

1. Request the latest `.pot` file from the plugin developers
2. Create or update your locale's `.po` file
3. Use Poedit or another translation tool to translate strings
4. Submit the `.po` file back to plugin developers
5. Plugin developers will generate the `.mo` and `.json` files

## Testing Translations

1. Place translation files in this `languages/` directory
2. Go to WordPress Settings → General → Site Language
3. Select your language
4. Clear cache if using a caching plugin
5. Visit the plugin's admin page and editor panel to verify translations

## Common Locales

- English (US): `en_US` (default, no translation files needed)
- Spanish (Spain): `es_ES`
- French (France): `fr_FR`
- German: `de_DE`
- Italian: `it_IT`
- Portuguese (Brazil): `pt_BR`
- Dutch: `nl_NL`
- Russian: `ru_RU`
- Japanese: `ja`
- Chinese (Simplified): `zh_CN`

## Troubleshooting

### Translations not showing

1. Verify the locale in WordPress Settings → General → Site Language
2. Check that file names match the locale exactly (including case)
3. Ensure `.mo` file exists (not just `.po`)
4. For JavaScript: Ensure JSON files exist with correct naming
5. Clear WordPress cache and browser cache
6. Verify `load_plugin_textdomain()` is called in the main plugin file

### JavaScript translations not working

1. Confirm `wp_set_script_translations()` is called after `wp_enqueue_script()`
2. Check that JSON files exist with correct naming: `{domain}-{locale}-{handle}.json`
3. Verify `wp-i18n` is in the script dependencies
4. Check browser console for JavaScript errors

## Resources

- [WordPress Plugin Handbook - Internationalization](https://developer.wordpress.org/plugins/internationalization/)
- [WP-CLI i18n Command](https://developer.wordpress.org/cli/commands/i18n/)
- [Poedit Translation Tool](https://poedit.net/)
- [GlotPress (WordPress.org Translation Platform)](https://translate.wordpress.org/)
