<?php

namespace SEMFE;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Main Plugin Class
 */
class Plugin {
    /**
     * Instance
     */
    private static $_instance = null;

    /**
     * Category Manager
     */
    public $category_manager;

    /**
     * Export Manager
     */
    public $export_manager;

    /**
     * Import Manager
     */
    public $import_manager;

    /**
     * REST API
     */
    public $rest_api;

    /**
     * Network Manager (PRO only, multisite)
     */
    public $network_manager;

    /**
     * Instance
     */
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    /**
     * Constructor
     */
    private function __construct() {
        $this->load_dependencies();
        $this->init_components();
        $this->register_hooks();
    }

    /**
     * Load dependencies
     */
    private function load_dependencies() {
        require_once SEMFE_PATH . 'includes/class-category-manager.php';
        require_once SEMFE_PATH . 'includes/class-export-manager.php';
        require_once SEMFE_PATH . 'includes/class-import-manager.php';
        require_once SEMFE_PATH . 'includes/class-backup-manager.php';
        require_once SEMFE_PATH . 'includes/class-rest-api.php';
        require_once SEMFE_PATH . 'includes/class-admin-page.php';
    }

    /**
     * Initialize components
     */
    private function init_components() {
        $this->category_manager = new Category_Manager();
        $this->export_manager = new Export_Manager($this->category_manager);
        $this->import_manager = new Import_Manager($this->category_manager);
        $this->rest_api = new REST_API($this->export_manager, $this->import_manager, $this->network_manager ?? null);
        // Initialize admin page.
        if ( is_admin() ) {
            new Admin_Page($this);
        }
    }

    /**
     * Register hooks
     */
    private function register_hooks() {
        // Enqueue editor scripts - use before_enqueue_scripts to ensure proper load order
        add_action( 'elementor/editor/before_enqueue_scripts', [$this, 'enqueue_editor_scripts'] );
        // Add custom panel to Site Settings
        add_action( 'elementor/kit/register_tabs', [$this, 'register_custom_kit_tab'] );
    }

    /**
     * Enqueue editor scripts
     */
    public function enqueue_editor_scripts() {
        wp_enqueue_script(
            'semfe-editor',
            SEMFE_URL . 'assets/js/editor-panel.js',
            [
                'jquery',
                'elementor-editor',
                'elementor-v2-editor-app-bar',
                'wp-i18n'
            ],
            SEMFE_VERSION,
            true
        );
        // Set script translations for JavaScript i18n
        wp_set_script_translations( 'semfe-editor', 'settings-manager-for-elementor', SEMFE_PATH . 'languages' );
        // Pass admin page URL to JavaScript
        wp_localize_script( 'semfe-editor', 'semfeConfig', [
            'adminUrl' => admin_url( 'admin.php?page=settings-manager-for-elementor' ),
        ] );
    }

    /**
     * Register custom kit tab
     */
    public function register_custom_kit_tab( $kit ) {
        // This will be used to add custom functionality to Site Settings
        // For now, we'll use a custom button added via JavaScript
    }

}
