(function($) {
    'use strict';

    // Import WordPress i18n functions
    const { __, _x, sprintf } = wp.i18n;

    // Check if editorAppBar API is available
    if (!window.elementorV2 || !window.elementorV2.editorAppBar) {
        console.error(__('SEMFE: Elementor top bar API not available. Requires Elementor 3.23.0+', 'settings-manager-for-elementor'));
        return;
    }

    // Register menu item in Elementor top bar
    const mainMenu = window.elementorV2.editorAppBar.mainMenu;

    mainMenu.registerAction({
        id: 'semfe-settings-manager',
        group: 'default',
        priority: 5,
        useProps: function() {
            return {
                title: __('Settings Manager', 'settings-manager-for-elementor'),
                icon: window.elementorV2.icons.SFTPIcon,
                onClick: function() {
                    // Open Settings Manager admin page in new tab
                    window.open(semfeConfig.adminUrl, '_blank');
                }
            };
        }
    });

})(jQuery);
