<?php
/**
 * Dashboard template.
 *
 * @var int   $total_sessions Total sessions in table.
 * @var array $stats           Session Shredder statistics.
 *
 * @package Session_Shredder
 */

defined( 'ABSPATH' ) || exit;

$total_sessions = isset( $total_sessions ) ? (int) $total_sessions : 0;
$stats          = isset( $stats ) && is_array( $stats ) ? $stats : array();
$pruned_today   = isset( $stats['pruned_today'] ) ? (int) $stats['pruned_today'] : 0;
$pruned_total   = isset( $stats['pruned_total'] ) ? (int) $stats['pruned_total'] : 0;
$last_prune_ts  = isset( $stats['last_prune'] ) ? (int) $stats['last_prune'] : 0;
$next_run_ts    = wp_next_scheduled( 'session_shredder_cron' );
?>
<div class="wrap session-shredder-wrap">
	<h1><?php esc_html_e( 'Session Shredder Dashboard', 'session-shredder-for-woocommerce' ); ?></h1>

	<?php settings_errors( 'session-shredder' ); ?>

	<div class="session-shredder-grid">
		<div class="session-shredder-card session-shredder-card-main">
			<h2 class="session-shredder-card-title"><?php esc_html_e( 'Overview', 'session-shredder-for-woocommerce' ); ?></h2>
			<p class="description session-shredder-overview-subtitle">
				<?php esc_html_e( 'Snapshot of current sessions and the most recent pruning activity.', 'session-shredder-for-woocommerce' ); ?>
			</p>
			<div class="session-shredder-stats">
				<p>
					<?php esc_html_e( 'Active sessions:', 'session-shredder-for-woocommerce' ); ?>
					<strong><?php echo esc_html( number_format_i18n( $total_sessions ) ); ?></strong>
				</p>
				<p>
					<?php esc_html_e( 'Pruned Today:', 'session-shredder-for-woocommerce' ); ?>
					<strong><?php echo esc_html( number_format_i18n( $pruned_today ) ); ?></strong>
				</p>
				<p>
					<?php esc_html_e( 'Total Pruned:', 'session-shredder-for-woocommerce' ); ?>
					<strong><?php echo esc_html( number_format_i18n( $pruned_total ) ); ?></strong>
				</p>
				<?php if ( $last_prune_ts > 0 ) : ?>
					<p>
						<?php esc_html_e( 'Last run:', 'session-shredder-for-woocommerce' ); ?>
						<strong><?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $last_prune_ts ) ); ?></strong>
					</p>
				<?php endif; ?>
				<?php if ( $next_run_ts ) : ?>
					<p>
						<?php esc_html_e( 'Next scheduled run:', 'session-shredder-for-woocommerce' ); ?>
						<strong><?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $next_run_ts ) ); ?></strong>
					</p>
				<?php endif; ?>
			</div>

			<form method="post">
				<?php wp_nonce_field( 'session_shredder_manual_prune_action', 'session_shredder_manual_prune_nonce' ); ?>
				<p class="session-shredder-actions">
					<input type="submit" name="session_shredder_manual_prune" value="<?php esc_attr_e( 'Prune Now', 'session-shredder-for-woocommerce' ); ?>" class="button button-primary" />
					<input type="submit" name="session_shredder_dry_run" value="<?php esc_attr_e( 'Analyze (dry run)', 'session-shredder-for-woocommerce' ); ?>" class="button" />
				</p>
			</form>
		</div>

		<div class="session-shredder-card session-shredder-card-chart">
			<h2 class="session-shredder-card-title"><?php esc_html_e( 'Active & pruned sessions per run', 'session-shredder-for-woocommerce' ); ?></h2>
			<canvas id="mlScoresChart" width="600" height="260"></canvas>
		</div>
	</div>

	<div class="session-shredder-runs">
		<h2><?php esc_html_e( 'Recent runs', 'session-shredder-for-woocommerce' ); ?></h2>
		<?php
		$recent_runs = array();
		if ( ! empty( $stats['last_runs'] ) && is_array( $stats['last_runs'] ) ) {
			$recent_runs = array_reverse( $stats['last_runs'] );
			$recent_runs = array_slice( $recent_runs, 0, 5 );
		}
		?>
		<?php if ( ! empty( $recent_runs ) ) : ?>
			<table class="session-shredder-runs-table">
				<thead>
					<tr>
						<th scope="col"><?php esc_html_e( 'Run time', 'session-shredder-for-woocommerce' ); ?></th>
						<th scope="col"><?php esc_html_e( 'Pruned', 'session-shredder-for-woocommerce' ); ?></th>
						<th scope="col"><?php esc_html_e( 'Active before', 'session-shredder-for-woocommerce' ); ?></th>
						<th scope="col"><?php esc_html_e( 'Active after', 'session-shredder-for-woocommerce' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ( $recent_runs as $run ) : ?>
						<tr>
							<td>
								<?php
								$ts = isset( $run['timestamp'] ) ? (int) $run['timestamp'] : 0;
								if ( $ts > 0 ) {
									echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $ts ) );
								} else {
									esc_html_e( 'N/A', 'session-shredder-for-woocommerce' );
								}
								?>
							</td>
							<td><?php echo esc_html( isset( $run['pruned'] ) ? (int) $run['pruned'] : 0 ); ?></td>
							<td><?php echo esc_html( isset( $run['total_before'] ) ? (int) $run['total_before'] : 0 ); ?></td>
							<td><?php echo esc_html( isset( $run['total_after'] ) ? (int) $run['total_after'] : 0 ); ?></td>
						</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		<?php else : ?>
			<p class="description"><?php esc_html_e( 'No prune runs have been recorded yet. Once pruning runs, you will see a short history here.', 'session-shredder-for-woocommerce' ); ?></p>
		<?php endif; ?>
	</div>

	<div class="session-shredder-promo">
		<span class="dashicons dashicons-performance session-shredder-promo-icon" aria-hidden="true"></span>
		<div class="session-shredder-promo-content">
			<div class="session-shredder-promo-text">
				<h3><?php esc_html_e( 'Supercharge WooCommerce performance with Mamba', 'session-shredder-for-woocommerce' ); ?></h3>
				<p>
					<?php
					printf(
						wp_kses(
							/* translators: 1: opening link tag, 2: closing link tag. */
							__( 'Lightning-fast WooCommerce for real stores, not blogs. %1$sMamba%2$s is a WooCommerce-native performance stack with full-page and Store API caching, object cache integration, smart warmup and invalidation, and checkout/media/DB optimizations. It keeps catalog pages fast, carts accurate, and checkouts smooth while working with your CDN and page builder.', 'session-shredder-for-woocommerce' ),
							array(
								'a' => array(
									'href'   => array(),
									'target' => array(),
									'rel'    => array(),
								),
							)
						),
						'<a href="' . esc_url( 'https://mambaspeed.com/?utm_source=session-shredder&utm_medium=plugin&utm_campaign=dashboard' ) . '" target="_blank" rel="noopener noreferrer">',
						'</a>'
					);
					?>
				</p>
			</div>
			<p class="session-shredder-promo-cta">
				<a class="button button-secondary" href="<?php echo esc_url( 'https://mambaspeed.com/?utm_source=session-shredder&utm_medium=plugin&utm_campaign=dashboard' ); ?>" target="_blank" rel="noopener noreferrer">
					<?php esc_html_e( 'Supercharge your WooCommerce store', 'session-shredder-for-woocommerce' ); ?>
				</a>
			</p>
		</div>
	</div>
</div>
