(function (window, document, $) {
	'use strict';

	var chartInstance = null;
	var refreshIntervalMs = 30000; // 30 seconds.

	function fetchStatsAndRender() {
		var canvas = document.getElementById('mlScoresChart');

		if (!canvas || typeof Chart === 'undefined' || typeof session_shredder_ajax === 'undefined' || !session_shredder_ajax.ajax_url) {
			return;
		}

		$.ajax({
			url: session_shredder_ajax.ajax_url,
			method: 'POST',
			dataType: 'json',
			data: {
				action: 'session_shredder_get_stats',
				nonce: session_shredder_ajax.nonce
			}
		})
			.done(function (response) {
				if (!response || !response.success || !response.data) {
					return;
				}

				var data = response.data;
				var ctx = canvas.getContext('2d');

				if (!chartInstance) {
					chartInstance = new Chart(ctx, {
						type: 'line',
						data: {
							labels: data.labels,
							datasets: [
								{
									label: 'Pruned sessions per run',
									data: data.values,
									borderColor: '#ff4d4f',
									backgroundColor: 'rgba(255, 77, 79, 0.15)',
									tension: 0.25,
									pointRadius: 3
								},
								{
									label: 'Active sessions per run',
									data: data.values_total,
									borderColor: '#1890ff',
									backgroundColor: 'rgba(24, 144, 255, 0.10)',
									tension: 0.25,
									pointRadius: 2
								}
							]
						},
						options: {
							plugins: {
								legend: { display: true }
							},
							scales: {
								y: {
									beginAtZero: true
								}
							}
						}
					});
				} else {
					chartInstance.data.labels = data.labels;
					if (chartInstance.data.datasets && chartInstance.data.datasets.length) {
						chartInstance.data.datasets[0].data = data.values;
						if (chartInstance.data.datasets[1]) {
							chartInstance.data.datasets[1].data = data.values_total;
						}
					}
					chartInstance.update();
				}
			})
			.fail(function () {
				// Fail silently; the chart is non-critical.
			});
	}

	function initChart() {
		fetchStatsAndRender();
		// Auto-refresh while the page is open.
		window.setInterval(fetchStatsAndRender, refreshIntervalMs);
	}

	if (typeof $ !== 'undefined') {
		$(function () {
			initChart();
		});
	} else {
		document.addEventListener('DOMContentLoaded', initChart);
	}
})(window, document, window.jQuery);
