/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./src/**/*.{php,html,js,jsx}",
    "./node_modules/tailwind-datepicker-react/dist/**/*.js",
    "./node_modules/react-tailwindcss-datepicker/dist/index.esm.js",
  ],
  safelist: [
    "tab-element",
    "tabs-group-container , text-violet-200",
    "flex",
    "items-center",
    "mr-2",
    "gap-8",
    "md:max-w-[65%]",
    "[@media(max-width:735px)]:grow-0",
    "[@media(max-width:735px)]:justify-between",
    "[@media(max-width:735px)]:w-full",
    "[@media(max-width:735px)]:flex-col",
    "[@media(max-width:735px)]:items-start",
  ],
  theme: {
    extend: {
      fontFamily: {
        sans: ["Inter"],
      },
      blur: {
        sm: "4px",
      },
      spacing: {
        0: "0rem",
        0.5: "0.125rem",
        1: "0.25rem",
        1.5: "0.375rem",
        2: "0.5rem",
        3: "0.75rem",
        4: "1rem",
        5: "1.25rem",
        6: "1.5rem",
        8: "2rem",
        xxs: "0.125rem",
        xs: "0.25rem",
        sm: "0.375rem",
        md: "0.5rem",
        lg: "0.75rem",
        xl: "1rem",
        "2xl": "1.25rem",
        "3xl": "1.5rem",
        "4xl": "2rem",
        "5xl": "2.5rem",
        "6xl": "3rem",
        "7xl": "4rem",
        "8xl": "5rem",
        "9xl": "6rem",
        "10xl": "8rem",
        "11xl": "10rem",
      },
      colors: {
        white: "#FFFFFF",
        black: "#000000",
        gray: {
          25: "#FCFCFD",
          50: "#F9FAFB",
          100: "#F2F4F7",
          200: "#E4E7EC",
          300: "#D0D5DD",
          400: "#98A2B3",
          500: "#667085",
          600: "#475467",
          700: "#344054",
          800: "#182230",
          900: "#101828",
          950: "#0C111D",
        },
        brand: {
          25: "#FCFAFF",
          50: "#F9F5FF",
          100: "#F4EBFF",
          200: "#E9D7FE",
          300: "#D6BBFB",
          400: "#B692F6",
          500: "#9D49EC",
          600: "#8217E5",
          700: "#7319C6",
          800: "#6B389E",
          900: "#4D307D",
          950: "#351C5F",
        },
        error: {
          25: "#FFFBFA",
          50: "#FEF3F2",
          100: "#FEE4E2",
          200: "#FECDCA",
          300: "#FDA29B",
          400: "#F97066",
          500: "#F04438",
          600: "#D92D20",
          700: "#B42318",
          800: "#912018",
          900: "#7A271A",
          950: "#55160C",
        },
        warning: {
          25: "#FFFCF5",
          50: "#FFFAEB",
          100: "#FEF0C7",
          200: "#FEDF89",
          300: "#FEC84B",
          400: "#FDB022",
          500: "#F79009",
          600: "#DC6803",
          700: "#B54708",
          800: "#93370D",
          900: "#7A2E0E",
          950: "#4E1D09",
        },
        success: {
          25: "#F6FEF9",
          50: "#ECFDF3",
          100: "#DCFAE6",
          200: "#ABEFC6",
          300: "#75E0A7",
          400: "#47CD89",
          500: "#17B26A",
          600: "#079455",
          700: "#067647",
          800: "#085D3A",
          900: "#074D31",
          950: "#053321",
        },
        primary: {
          "button-bg": "#8217E5",
        },
        utility: {
          gray: {
            50: "#F9FAFB",
            200: "#E4E7EC",
            700: "#344054",
          },
          brand: {
            50: "#F9F5FF",
            200: "#E9D6FF",
            700: "#7319C6",
          },
          error: {
            50: "#FEF3F2",
            200: "#FECDCA",
            700: "#B42318",
          },
          warning: {
            50: "#FFFAEB",
            200: "#FEDF89",
            700: "#B54708",
          },
          success: {
            50: "#ECFDF3",
            200: "#ABEFC6",
            700: "#067647",
          },
          "gray-blue": {
            50: "#F8F9FC",
            200: "#D5D9EB",
            700: "#363F72",
          },
          "blue-ligth": {
            50: "#F0F9FF",
            200: "#B9E6FE",
            700: "#026AA2",
          },
          blue: {
            50: "#EFF8FF",
            200: "#B2DDFF",
            700: "#175CD3",
          },
          indigo: {
            50: "#EEF4FF",
            200: "#C7D7FE",
            700: "#3538CD",
          },
          purple: {
            50: "#F4F3FF",
            200: "#D9D6FE",
            700: "#5925DC",
          },
          pink: {
            50: "#FDF2FA",
            200: "#FCCEEE",
            700: "#C11574",
          },
          orange: {
            50: "#FEF6EE",
            200: "#F9DBAF",
            700: "#B93815",
          },
        },
      },
      boxShadow: {
        "combined-gray": `
        0px 1px 2px 0px #1018280D,
        inset 0px -2px 0px 0px #1018280D,
        inset 0px 0px 0px 1px #1018282E
      `,
        "combined-brand": `
      inset 0px -2px 0px 0px #1018280D,
      inset 0px 0px 0px 1px #D6BBFB
    `,
      },
      fontSize: {
        xs: ["0.75rem", "1.125rem"],
        sm: ["0.875rem", "1.25rem"],
        md: ["1rem", "1.5rem"],
        lg: ["1.125rem", "1.75rem"],
        xl: ["1.25rem", "1.875rem"],
        "display-xs": ["1.5rem", "2rem"],
        "display-sm": ["1.875rem", "2.375rem"],
        "display-md": ["2.25rem", "2.75rem", "-2%"],
        "display-lg": ["3rem", "3.75rem", "-2%"],
        "display-xl": ["3.75rem", "4.5rem", "-2%"],
        "display-2xl": ["4.5rem", "5.625rem", "-2%"],
      },
      fontWeight: {
        regular: 400,
        medium: 500,
        semibold: 600,
        bold: 700,
      },
    },
  },
  plugins: [],
  darkMode: "class",
};
