<?php
/**
 * Uninstall cleanup for Server IP Dashboard plugin.
 * Deletes plugin options and transients on uninstall.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Keys used by the plugin.
$option_key            = 'srvip_settings';
$external_ip_transient = 'srvip_external_ip';

/**
 * Delete per-site data.
 *
 * @param string $option_key            Option key to delete.
 * @param string $external_ip_transient Transient key to delete.
 */
function srvip_delete_site_data( $option_key, $external_ip_transient ) {
	// Remove per-site option.
	delete_option( $option_key );

	// Remove per-site transient and any network-level transient with same key.
	delete_transient( $external_ip_transient );
	delete_site_transient( $external_ip_transient );
}

if ( ! is_multisite() ) {
	// Single site uninstall.
	srvip_delete_site_data( $option_key, $external_ip_transient );
	return;
}

// Multisite: iterate over all sites and delete per-site data.
$sites = get_sites( array( 'fields' => 'ids' ) );
if ( $sites && is_array( $sites ) ) {
	$original_blog_id = get_current_blog_id();

	foreach ( $sites as $site_id ) {
		switch_to_blog( (int) $site_id );
		srvip_delete_site_data( $option_key, $external_ip_transient );
		restore_current_blog();
	}

	// Ensure we end back on the original blog context.
	if ( get_current_blog_id() !== (int) $original_blog_id ) {
		switch_to_blog( (int) $original_blog_id );
		restore_current_blog();
	}
}
