/* global jQuery, SrvipData */
jQuery(document).ready(function ($) {
  'use strict';

  var $internal = $('#srvip-internal');
  var $external = $('#srvip-external');
  var $refreshBtn = $('#srvip-refresh');
  var $updated = $('#srvip-updated');

  var ajaxUrl = (SrvipData && SrvipData.ajaxUrl) || '';
  var nonce = (SrvipData && SrvipData.nonce) || '';
  var intervalSec = parseInt((SrvipData && SrvipData.refreshInterval) || 0, 10) || 0;
  var updatedLabel = (SrvipData && SrvipData.updatedLabel) || 'Last updated:';
  var errorLabel = (SrvipData && SrvipData.errorLabel) || 'Error fetching IP';

  var autoTimer = null;
  var inFlight = false;

  function setLoadingState(isLoading) {
    inFlight = isLoading;
    $refreshBtn.prop('disabled', isLoading);
    if (isLoading) {
      // Light UX hint; keep it text-only for simplicity
      $updated.text('...');
    }
  }

  function updateUI(data) {
    if (data && typeof data === 'object') {
      if (typeof data.internal_ip !== 'undefined') {
        $internal.text(data.internal_ip || 'Unavailable');
      }
      if (typeof data.external_ip !== 'undefined') {
        $external.text(data.external_ip || 'Unavailable');
      }
      // Prefer server-side timestamp for consistency, fallback to client time
      var ts = (data.timestamp && String(data.timestamp)) || new Date().toLocaleString();
      $updated.text(updatedLabel + ' ' + ts);
    }
  }

  function showError() {
    $external.text(errorLabel);
    var ts = new Date().toLocaleString();
    $updated.text(updatedLabel + ' ' + ts);
  }

  function fetchIPs() {
    if (!ajaxUrl || !nonce || inFlight) {
      return;
    }
    setLoadingState(true);

    $.post(
      ajaxUrl,
      {
        action: 'srvip_get_ips',
        security: nonce
      }
    )
      .done(function (response) {
        if (response && response.success && response.data) {
          updateUI(response.data);
        } else {
          showError();
        }
      })
      .fail(function () {
        showError();
      })
      .always(function () {
        setLoadingState(false);
      });
  }

  // Manual refresh
  $refreshBtn.on('click', function (e) {
    e.preventDefault();
    fetchIPs();
  });

  // Initial fetch
  fetchIPs();

  // Auto-refresh if configured
  if (intervalSec > 0) {
    // Enforce a sane minimum to avoid hammering; PHP also caps but JS helps UX
    var minSec = Math.max(10, intervalSec);
    autoTimer = setInterval(fetchIPs, minSec * 1000);
  }

  // Cleanup (if the dashboard navigates via AJAX in some admin UIs)
  $(window).on('unload', function () {
    if (autoTimer) {
      clearInterval(autoTimer);
      autoTimer = null;
    }
  });
});
