<?php
/**
 * Abstract API Entity.
 *
 * @package SeriouslySimplePodcasting
 * @since 2.23.0
 */

namespace SeriouslySimplePodcasting\Entities;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Abstract API entity class.
 *
 * @since 2.23.0
 * @author Serhiy Zakharchenko
 */
abstract class Abstract_API_Entity extends Abstract_Entity {

	/**
	 * Response code from API.
	 *
	 * @var int
	 */
	public $code;

	/**
	 * Response message from API.
	 *
	 * @var string
	 */
	public $message;

	/**
	 * Whether the API request was successful.
	 *
	 * @var bool
	 */
	public $success = false;
}
