<?php
/**
 * Plugin Name: Serial Numbers & License Keys for WooCommerce
 * Plugin URI: https://wordpress.org/plugins/serial-numbers-license-keys-for-woocommerce/
 * Description: Sell and manage serial numbers and license keys for Simple and Variable WooCommerce products.
 * Version: 1.0.2
 * Requires at least: 5.6
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 * Author: Shafiq
 * Author URI: https://wordpress.org/users/shafiq1010/
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: serial-numbers-license-keys-for-woocommerce
 * Domain Path: /languages
 */

defined( 'ABSPATH' ) || exit;

// Define Constants
define( 'VSMGR_VERSION', '1.0.2' );
define( 'VSMGR_DB_VERSION', '1.0.2' );
define( 'VSMGR_IS_PRO', false ); // Set to true in Pro version

define( 'VSMGR_FILE', __FILE__ );
define( 'VSMGR_PATH', plugin_dir_path( __FILE__ ) );
define( 'VSMGR_URL', plugin_dir_url( __FILE__ ) );

/**
 * Main Plugin Class
 */
class VSMGR_Plugin {

    /**
     * Instance
     */
    private static $instance = null;

    /**
     * Get Instance
     */
    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
    public function __construct() {
        $this->includes();
        $this->init_hooks();
    }

    /**
     * Include Files
     */
    private function includes() {
        require_once VSMGR_PATH . 'includes/class-vsm-db.php';
        require_once VSMGR_PATH . 'includes/class-vsm-common.php';
        
        if ( is_admin() ) {
            require_once VSMGR_PATH . 'includes/admin/class-vsm-admin.php';
            require_once VSMGR_PATH . 'includes/admin/class-vsm-product.php';
            require_once VSMGR_PATH . 'includes/admin/class-vsm-import-export.php';
            require_once VSMGR_PATH . 'includes/admin/class-vsm-reports.php';
            require_once VSMGR_PATH . 'includes/admin/class-vsm-settings.php';
        }

        require_once VSMGR_PATH . 'includes/woocommerce/class-vsm-order.php';
    }

    /**
     * Hooks
     */
    private function init_hooks() {
        register_activation_hook( VSMGR_FILE, array( 'VSMGR_DB', 'install' ) );
    }
}

/**
 * Global Accessor
 */
function VSMGR() {
    return VSMGR_Plugin::instance();
}

// Kickoff
VSMGR();
