<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package Variation Serial Manager
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// 1. Check if user agreed to delete data
if ( get_option( 'vsmgr_delete_data_on_uninstall' ) !== 'yes' ) {
    return;
}

global $wpdb;

// 2. Drop Custom Table
$table_name = $wpdb->prefix . 'variation_serials';
// Low risk since table name is constructed from prefix, but ideally verify or catch errors.
// Using standard query as per WP docs for generated table names.
$wpdb->query( "DROP TABLE IF EXISTS $table_name" );

// 3. Delete Options (Safe List)
$option_keys = array(
    'vsmgr_auto_complete_order',
    'vsmgr_delete_data_on_uninstall',
    'vsmgr_reuse_keys',
    'vsmgr_revoke_keys',
    'vsmgr_hide_keys',
    'vsmgr_disable_software_support',
    'vsmgr_manage_stock',
    'vsmgr_pdf_invoices',
    'vsmgr_stock_notification_email',
    'vsmgr_stock_threshold',
    'vsmgr_notification_recipient',
);

foreach ( $option_keys as $key ) {
    delete_option( $key );
}

// 4. Clear Scheduled Hooks (if any)
wp_clear_scheduled_hook( 'vsm_daily_cleanup' );

