<?php
defined( 'ABSPATH' ) || exit;

class VSMGR_DB {

    /**
     * Table Name
     */
    public static function get_table_name() {
        global $wpdb;
        return $wpdb->prefix . 'variation_serials';
    }

    /**
     * Install / Create Table
     */
    public static function install() {
        global $wpdb;

        $table_name = self::get_table_name();
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE $table_name (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            product_id bigint(20) NOT NULL,
            variation_id bigint(20) NOT NULL DEFAULT '0',
            serial_key longtext NOT NULL,
            activation_limit int(9) NOT NULL DEFAULT '0',
            validity int(9) NOT NULL DEFAULT '0',
            status varchar(20) NOT NULL DEFAULT 'available',
            order_id bigint(20) NOT NULL DEFAULT '0',
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            KEY product_id (product_id),
            KEY variation_id (variation_id),
            KEY status (status)
        ) $charset_collate;";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
    }
}
