<?php
defined( 'ABSPATH' ) || exit;

class VSMGR_Common {
    
    /**
     * Generate Key String based on Rule
     */
    public static function generate_key( $rule = '' ) {
        if ( empty( $rule ) ) {
            // Default Format: XXXX-XXXX-XXXX-XXXX
            return implode( '-', str_split( strtoupper( wp_generate_password( 16, false ) ), 4 ) );
        }

        // Rule Parser: Allowed tag {number}
        return preg_replace_callback( '/\{(\d+)\}/', function( $matches ) {
            $length = intval( $matches[1] );
            return strtoupper( wp_generate_password( $length, false ) );
        }, $rule );
    }
}
