<?php
defined( 'ABSPATH' ) || exit;

class VSMGR_Settings {

    public static function render() {
        // Save Handler
        if ( isset( $_POST['vsmgr_save_settings'] ) && check_admin_referer( 'vsmgr_save_settings_nonce' ) ) {
            if ( ! current_user_can( 'manage_woocommerce' ) ) {
                wp_die( esc_html__( 'Unauthorized', 'serial-numbers-license-keys-for-woocommerce' ) );
            }
            self::save_settings();
            echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'Settings saved.', 'serial-numbers-license-keys-for-woocommerce' ) . '</p></div>';
        }

        // Get Options
        $opts = array(
            'auto_complete' => get_option( 'vsmgr_auto_complete_order', 'no' ) == 'yes',
            'reuse_keys'    => get_option( 'vsmgr_reuse_keys', 'no' ) == 'yes',
            'revoke_keys'   => get_option( 'vsmgr_revoke_keys', 'no' ) == 'yes',
            'hide_keys'     => get_option( 'vsmgr_hide_keys', 'no' ) == 'yes',
            'disable_sw'    => get_option( 'vsmgr_disable_software_support', 'no' ) == 'yes',
            'manage_stock'  => get_option( 'vsmgr_manage_stock', 'no' ) == 'yes',
            'pdf_invoices'  => get_option( 'vsmgr_pdf_invoices', 'no' ) == 'yes',
            'stock_email'   => get_option( 'vsmgr_stock_notification_email', 'no' ) == 'yes',
            'stock_thresh'  => get_option( 'vsmgr_stock_threshold', '5' ),
            'notify_email'  => get_option( 'vsmgr_notification_recipient', get_option( 'admin_email' ) ),
        );

        ?>
        <div class="wrap vsm-wrapper">
            <h1><?php esc_html_e( 'Settings', 'serial-numbers-license-keys-for-woocommerce' ); ?></h1>
            
            <form method="post" action="" class="vsm-settings-container">
                <?php wp_nonce_field( 'vsmgr_save_settings_nonce' ); ?>
                
                <div class="vsm-settings-main">
                    <div class="vsm-card">
                        <h3><?php esc_html_e( 'General Settings', 'serial-numbers-license-keys-for-woocommerce' ); ?></h3>
                        <p class="description"><?php esc_html_e( 'These options determine the behavior and operation of the plugin.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
                        
                        <table class="form-table">
                            <tr>
                                <th><?php esc_html_e( 'Auto-complete orders', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_auto_complete_order" value="yes" <?php checked( $opts['auto_complete'] ); ?>>
                                        <?php esc_html_e( 'Automatically completes orders after successful payments.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                </td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e( 'Uninstall Data', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_delete_data_on_uninstall" value="yes" <?php checked( get_option( 'vsmgr_delete_data_on_uninstall' ) == 'yes' ); ?>>
                                        <?php esc_html_e( 'Delete all plugin data on uninstall.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                    <p class="description"><?php esc_html_e( 'Check this box if you want to wipe all data when you delete the plugin.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
                                </td>
                            </tr>
                            <?php if ( VSMGR_IS_PRO ) : ?>
                            <tr>
                                <th><?php esc_html_e( 'Reuse keys', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_reuse_keys" value="yes" <?php checked( $opts['reuse_keys'] ); ?>>
                                        <?php esc_html_e( 'Recover failed, refunded keys for selling again.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                    <p class="description"><?php esc_html_e( 'If you enable this option, the keys will be available for selling again if the order is refunded or failed.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e( 'Revoke keys', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_revoke_keys" value="yes" <?php checked( $opts['revoke_keys'] ); ?>>
                                        <?php esc_html_e( 'Revoke keys when the order status changes to cancelled or refunded.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                </td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <th><?php esc_html_e( 'Hide keys', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_hide_keys" value="yes" <?php checked( $opts['hide_keys'] ); ?>>
                                        <?php esc_html_e( 'Keys will be masked in the list table.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                </td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e( 'Disable software support', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_disable_software_support" value="yes" <?php checked( $opts['disable_sw'] ); ?>>
                                        <?php esc_html_e( 'Disable Software Licensing support & API functionalities.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                </td>
                            </tr>
                            <?php if ( VSMGR_IS_PRO ) : ?>
                            <tr>
                                <th><?php esc_html_e( 'Manage Stocks', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_manage_stock" value="yes" <?php checked( $opts['manage_stock'] ); ?>>
                                        <?php esc_html_e( 'Enable stock management for key-enabled products.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                    <p class="description"><?php esc_html_e( 'This works only if you select "Manually Added" as the key source and enable stock management for the product.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e( 'WooCommerce PDF Invoices', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_pdf_invoices" value="yes" <?php checked( $opts['pdf_invoices'] ); ?>>
                                        <?php esc_html_e( 'Enable WooCommerce PDF Invoices.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                    <p class="description"><?php esc_html_e( 'Show serial keys in the invoice.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </table>
                    </div>

                    <?php if ( VSMGR_IS_PRO ) : ?>
                    <div class="vsm-card">
                        <h3><?php esc_html_e( 'Stock Notification', 'serial-numbers-license-keys-for-woocommerce' ); ?></h3>
                        <p class="description"><?php esc_html_e( 'These options determine the operation of the key’s stock notification.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>

                        <table class="form-table">
                            <tr>
                                <th><?php esc_html_e( 'Stock notification email', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="vsmgr_stock_notification_email" value="yes" <?php checked( $opts['stock_email'] ); ?>>
                                        <?php esc_html_e( 'Sends notification emails when key stock is low.', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                                    </label>
                                </td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e( 'Stock threshold', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <input type="number" name="vsmgr_stock_threshold" value="<?php echo esc_attr( $opts['stock_thresh'] ); ?>" class="small-text">
                                    <p class="description"><?php esc_html_e( 'An email notification will be sent when the key stock falls below the specified number.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th><?php esc_html_e( 'Notification recipient email', 'serial-numbers-license-keys-for-woocommerce' ); ?></th>
                                <td>
                                    <input type="email" name="vsmgr_notification_recipient" value="<?php echo esc_attr( $opts['notify_email'] ); ?>" class="regular-text">
                                    <p class="description"><?php esc_html_e( 'The email address which will be used to send email notifications.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
                                </td>
                            </tr>
                        </table>

                        <p class="submit"><input type="submit" name="vsmgr_save_settings" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'serial-numbers-license-keys-for-woocommerce' ); ?>"></p>
                    </div>
                    <?php else: ?>
                         <p class="submit"><input type="submit" name="vsmgr_save_settings" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'serial-numbers-license-keys-for-woocommerce' ); ?>"></p>
                    <?php endif; ?>
                </div>

                <!-- Sidebar -->
                <div class="vsm-settings-sidebar">
                    <div class="vsm-card">
                        <h3><?php esc_html_e( 'Want More?', 'serial-numbers-license-keys-for-woocommerce' ); ?></h3>
                        <p><?php esc_html_e( 'This plugin offers a premium version which comes with the following features:', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
                        <ul>
                            <li><?php esc_html_e( 'Create and assign keys for WooCommerce variable products.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Generate bulk keys with your custom key generator rule.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Random & sequential key order for the generator rules.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Automatic key generator to auto-create & assign keys with orders.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'License key management option from the order page.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Support for bulk import/export of keys from/to CSV.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Send keys via SMS with Twilio.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Option to sell keys even if there are no available keys.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Custom deliverable quantity for single product.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Manual delivery option instead of automatic.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Email template customization for order confirmation & low stock.', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                            <li><?php esc_html_e( 'Many more ...', 'serial-numbers-license-keys-for-woocommerce' ); ?></li>
                        </ul>
                        <a href="<?php echo esc_url( admin_url('admin.php?page=vsm-upgrade') ); ?>" class="button vsm-upgrade-btn"><?php esc_html_e( 'Upgrade to PRO', 'serial-numbers-license-keys-for-woocommerce' ); ?></a>
                    </div>
                </div>

            </form>
        </div>
        <?php
    }

    private static function save_settings() {
        update_option( 'vsmgr_auto_complete_order', isset($_POST['vsmgr_auto_complete_order']) ? 'yes' : 'no' );
        update_option( 'vsmgr_delete_data_on_uninstall', isset($_POST['vsmgr_delete_data_on_uninstall']) ? 'yes' : 'no' );
        update_option( 'vsmgr_reuse_keys',    isset($_POST['vsmgr_reuse_keys']) ? 'yes' : 'no' );
        update_option( 'vsmgr_revoke_keys',   isset($_POST['vsmgr_revoke_keys']) ? 'yes' : 'no' );
        update_option( 'vsmgr_hide_keys',     isset($_POST['vsmgr_hide_keys']) ? 'yes' : 'no' );
        update_option( 'vsmgr_disable_software_support', isset($_POST['vsmgr_disable_software_support']) ? 'yes' : 'no' );
        update_option( 'vsmgr_manage_stock',  isset($_POST['vsmgr_manage_stock']) ? 'yes' : 'no' );
        update_option( 'vsmgr_pdf_invoices',  isset($_POST['vsmgr_pdf_invoices']) ? 'yes' : 'no' );
        update_option( 'vsmgr_stock_notification_email', isset($_POST['vsmgr_stock_notification_email']) ? 'yes' : 'no' );
        
        if ( isset( $_POST['vsmgr_stock_threshold'] ) ) {
            update_option( 'vsmgr_stock_threshold', intval( $_POST['vsmgr_stock_threshold'] ) );
        }
        
        if ( isset( $_POST['vsmgr_notification_recipient'] ) ) {
            update_option( 'vsmgr_notification_recipient', sanitize_email( $_POST['vsmgr_notification_recipient'] ) );
        }
    }
}
