<?php
defined( 'ABSPATH' ) || exit;

class VSMGR_Product_Admin {

    public function __construct() {
        // Simple Products
        add_filter( 'woocommerce_product_data_tabs', array( $this, 'add_tab' ) );
        add_action( 'woocommerce_product_data_panels', array( $this, 'add_tab_content' ) );
        add_action( 'woocommerce_process_product_meta', array( $this, 'save_settings' ) );

        // Variable Products
        add_action( 'woocommerce_product_after_variable_attributes', array( $this, 'add_variation_settings' ), 10, 3 );
        add_action( 'woocommerce_save_product_variation', array( $this, 'save_variation_settings' ), 10, 2 );
    }

    /**
     * Add Tab
     */
    public function add_tab( $tabs ) {
        $tabs['vsm_serials'] = array(
            'label'    => esc_html__( 'Serial Keys', 'serial-numbers-license-keys-for-woocommerce' ),
            'target'   => 'vsm_serials_options',
            'class'    => array( 'show_if_simple', 'show_if_variable' ),
        );
        return $tabs;
    }

    /**
     * Tab Content (Simple Product)
     */
    public function add_tab_content() {
        global $post;
        ?>
        <div id="vsm_serials_options" class="panel woocommerce_options_panel">
            <div class="options_group">
                <?php wp_nonce_field( 'vsmgr_save_product', 'vsmgr_nonce' ); ?>
                <p class="form-field"><strong><?php esc_html_e( 'Simple Product Settings', 'serial-numbers-license-keys-for-woocommerce' ); ?></strong></p>
                <p class="description"><?php esc_html_e( 'For Variable products, configure these settings inside each Variation tab.', 'serial-numbers-license-keys-for-woocommerce' ); ?></p>
            
                <?php
                // Enable
                woocommerce_wp_checkbox( array(
                    'id'            => '_vsmgr_enabled',
                    'label'         => esc_html__( 'Enable Serial Keys', 'serial-numbers-license-keys-for-woocommerce' ),
                    'description'   => esc_html__( 'Enable automatic key sales for this product.', 'serial-numbers-license-keys-for-woocommerce' ),
                ) );

                // Rule
                woocommerce_wp_text_input( array(
                    'id'            => '_vsmgr_rule',
                    'label'         => esc_html__( 'Generator Rule', 'serial-numbers-license-keys-for-woocommerce' ),
                    'placeholder'   => 'PREFIX-{4}-{4}',
                    'desc_tip'      => 'true',
                    'description'   => esc_html__( 'Pattern for auto-generation. Use {4} for random chars. Leave empty for default.', 'serial-numbers-license-keys-for-woocommerce' ),
                ) );
                ?>
            </div>
        </div>
        <?php
    }

    /**
     * Save Simple Product
     */
    public function save_settings( $post_id ) {
        // Verify Nonce
        if ( ! isset( $_POST['vsmgr_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['vsmgr_nonce'] ) ), 'vsmgr_save_product' ) ) {
            return;
        }

        if ( ! current_user_can( 'edit_post', $post_id ) ) {
            return;
        }

        $enabled = isset( $_POST['_vsmgr_enabled'] ) ? 'yes' : 'no';
        update_post_meta( $post_id, '_vsmgr_enabled', $enabled );

        if ( isset( $_POST['_vsmgr_rule'] ) ) {
            update_post_meta( $post_id, '_vsmgr_rule', sanitize_text_field( $_POST['_vsmgr_rule'] ) );
        }
    }

    /**
     * Variation Settings
     */
    public function add_variation_settings( $loop, $variation_data, $variation ) {
        $variation_id = $variation->ID;
        $enabled = get_post_meta( $variation_id, '_vsmgr_enabled', true );
        $rule = get_post_meta( $variation_id, '_vsmgr_rule', true );
        ?>
        <div class="vsm_variation_settings form-row form-row-full">
            <h4><?php esc_html_e( 'Serial Key Settings', 'serial-numbers-license-keys-for-woocommerce' ); ?></h4>
            
            <p class="form-row form-row-full">
                <label>
                    <input type="checkbox" class="checkbox" name="vsmgr_enabled[<?php echo esc_attr( $loop ); ?>]" <?php checked( $enabled, 'yes' ); ?> />
                    <?php esc_html_e( 'Enable Serial Keys for this variation', 'serial-numbers-license-keys-for-woocommerce' ); ?>
                </label>
            </p>

            <p class="form-row form-row-full">
                <label><?php esc_html_e( 'Generator Rule', 'serial-numbers-license-keys-for-woocommerce' ); ?></label>
                <input type="text" name="vsmgr_rule[<?php echo esc_attr( $loop ); ?>]" value="<?php echo esc_attr( $rule ); ?>" placeholder="PREFIX-{4}-{4}" />
                <span class="description"><?php esc_html_e( 'Leave empty to use parent or default.', 'serial-numbers-license-keys-for-woocommerce' ); ?></span>
            </p>
        </div>
        <?php
    }

    /**
     * Save Variation
     */
    public function save_variation_settings( $variation_id, $i ) {
        if ( ! current_user_can( 'edit_post', $variation_id ) ) {
            return;
        }
        
        $enabled = isset( $_POST['vsmgr_enabled'][$i] ) ? 'yes' : 'no';
        update_post_meta( $variation_id, '_vsmgr_enabled', $enabled );

        if ( isset( $_POST['vsmgr_rule'][$i] ) ) {
            update_post_meta( $variation_id, '_vsmgr_rule', sanitize_text_field( $_POST['vsmgr_rule'][$i] ) );
        }
    }
}
new VSMGR_Product_Admin();
