<?php
/**
 * Plugin Name: SentWatch – Email Uptime Monitoring
 * Plugin URI: https://panel.sentwatch.com/
 * Description: Monitor WordPress email delivery with instant notifications when problems occur. Get alerts immediately if your site stops sending emails.
 * Version: 1.0.0
 * Author: PianoWeb
 * Author URI: https://pianoweb.eu
 * Requires at least: 5.3
 * Tested up to: 6.9
 * Requires PHP: 7.2
 * License: GPL v2 or later
 * Text Domain: sentwatch-email-uptime-monitoring
 */

if (!defined('ABSPATH')) {
    exit;
}

// Define Constants
define('SENTWATCH_VERSION', '1.0.0');
define('SENTWATCH_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('SENTWATCH_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SENTWATCH_API_URL', 'https://panel.sentwatch.com/api/');
define('SENTWATCH_HEARTBEAT_DOMAIN', 'ping.sentwatch.com');

// Include Classes
require_once SENTWATCH_PLUGIN_DIR . 'includes/class-api.php';
require_once SENTWATCH_PLUGIN_DIR . 'includes/class-heartbeat.php';

if (is_admin()) {
    require_once SENTWATCH_PLUGIN_DIR . 'includes/class-admin.php';
}

require_once SENTWATCH_PLUGIN_DIR . 'includes/class-sentwatch.php';

// Initialize Plugin
function sentwatch_init() {
    $plugin = new SentWatch();
    $plugin->run();
}
add_action('plugins_loaded', 'sentwatch_init');

// Activation Hook
register_activation_hook(__FILE__, ['SentWatch', 'activate']);

// Deactivation Hook
register_deactivation_hook(__FILE__, ['SentWatch', 'deactivate']);

// =====================================================
// REST API ENDPOINT
// =====================================================
// Add REST endpoint for plugin status verification
add_action('rest_api_init', function () {
    register_rest_route('sentwatch/v1', '/status', [
        'methods' => 'GET',
        'callback' => 'sentwatch_rest_status',
        'permission_callback' => '__return_true', // Public endpoint for monitoring
    ]);
});

/**
 * REST API callback - Returns basic plugin status
 * Public endpoint - only returns non-sensitive information
 * Used by SentWatch panel to verify plugin is active
 * For detailed status information, use the authenticated /ping endpoint
 */
function sentwatch_rest_status() {
    return [
        'active' => true,
        'version' => SENTWATCH_VERSION,
    ];
}
