<?php

if (!defined('ABSPATH')) {
    exit;
}

class SentWatch_Heartbeat {

    private $api;

    public function __construct($api) {
        $this->api = $api;
    }

    public function init() {
        // Hook cron event
        add_action('sentwatch_send_heartbeat', [$this, 'send_heartbeat']);
    }

    /**
     * Invia heartbeat (EMAIL ONLY)
     *
     * IMPORTANT: SentWatch monitors email delivery, so we MUST use email heartbeats.
     * Using HTTP would defeat the purpose of the service.
     */
    public function send_heartbeat() {
        $site_uuid = get_option('sentwatch_site_uuid');

        if (!$site_uuid) {
            return;
        }

        // Send heartbeat via email - this is the ONLY way to verify email functionality
        $this->send_email_heartbeat();

        // Update local timestamp
        update_option('sentwatch_last_heartbeat', time());
    }

    /**
     * Invia heartbeat via email
     *
     * This is the core function that verifies email delivery is working.
     */
    public function send_email_heartbeat() {
        $heartbeat_email = get_option('sentwatch_heartbeat_email');
        if (!$heartbeat_email) return;

        $to = $heartbeat_email;
        $subject = 'SentWatch Heartbeat';
        $message = json_encode([
            'timestamp' => time(),
            'site_url' => get_site_url(),
            'version' => SENTWATCH_VERSION
        ]);
        $headers = ['Content-Type: text/plain; charset=UTF-8'];

        $sent = wp_mail($to, $subject, $message, $headers);

        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log("SentWatch Email Heartbeat sent to $to: " . ($sent ? 'SUCCESS' : 'FAILED'));
        }
    }

    /**
     * Test invio manuale
     */
    public function send_test_heartbeat() {
        $this->send_heartbeat();
        return true;
    }
}
