<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap sentwatch-wrap">
    <h1>
        <span class="dashicons dashicons-email-alt" style="font-size: 32px; width: 32px; height: 32px; margin-right: 10px;"></span>
        SentWatch
    </h1>

    <?php if (isset($_GET['success'])): ?>
        <div class="notice notice-success is-dismissible">
            <p>
                <?php 
                if ($_GET['success'] == 'connected') echo 'Connected successfully!';
                elseif ($_GET['success'] == 'disconnected') echo 'Disconnected successfully.';
                elseif ($_GET['success'] == 'heartbeat_sent') echo 'Test email sent successfully!';
                ?>
            </p>
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
        <div class="notice notice-error is-dismissible">
            <p>Error: <?php echo esc_html($_GET['error']); ?></p>
        </div>
    <?php endif; ?>

    <?php if (!$connected): ?>
        <!-- Connect View -->
        <div class="card sentwatch-card">
            <h2>Connect to SentWatch</h2>
            <p>Enter your API Key to start monitoring your email delivery.</p>
            <p>Don't have an account? <a href="https://panel.sentwatch.com/register.php" target="_blank">Register for free</a>.</p>
            
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                <input type="hidden" name="action" value="sentwatch_connect">
                <?php wp_nonce_field('sentwatch_connect_action', 'sentwatch_nonce'); ?>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="api_key">API Key</label></th>
                        <td>
                            <input name="api_key" type="text" id="api_key" value="" class="regular-text" placeholder="Enter your API Key here">
                            <p class="description">You can find your API Key in your <a href="https://panel.sentwatch.com/settings.php" target="_blank">SentWatch Dashboard</a>.</p>
                        </td>
                    </tr>
                </table>
                
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="Connect & Test">
                </p>
            </form>
        </div>
    <?php else: ?>
        <!-- Connected View -->
        <div class="card sentwatch-card">
            <div class="sentwatch-status-header">
                <h2>
                    Mail Status: 
                    <?php if ($status && isset($status['is_allowed_by_plan']) && $status['is_allowed_by_plan'] === false): ?>
                        <span class="status-badge status-down" style="background: #f59e0b; color: #fff;">Inactive (Plan Limit)</span>
                    <?php elseif ($status && isset($status['status']) && $status['status'] == 'up'): ?>
                        <span class="status-badge status-up">Mail Online</span>
                    <?php else: ?>
                        <span class="status-badge status-down">Issue Detected</span>
                    <?php endif; ?>
                </h2>

                <?php if ($status && isset($status['success']) && !$status['success']): ?>
                    <div class="notice notice-error inline" style="margin: 10px 0;">
                        <p><strong>API Error:</strong> <?php echo esc_html($status['error'] ?? 'Unknown error'); ?></p>
                    </div>
                <?php endif; ?>
                
                <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" onsubmit="return confirm('Are you sure you want to disconnect? Monitoring will stop.');">
                    <input type="hidden" name="action" value="sentwatch_disconnect">
                    <?php wp_nonce_field('sentwatch_disconnect_action', 'sentwatch_nonce'); ?>
                    <button type="submit" class="button button-link-delete">Disconnect</button>
                </form>
            </div>

            <?php if ($status && isset($status['is_allowed_by_plan']) && $status['is_allowed_by_plan'] === false): ?>
                <div class="notice notice-warning inline" style="margin: 10px 0 20px 0;">
                    <p><strong>Monitoring Paused:</strong> You have reached the site limit for your plan. Please upgrade your plan or disable other sites to resume monitoring for this site.</p>
                </div>
            <?php endif; ?>

            <div class="sentwatch-details">
                <p><strong>Site UUID:</strong> <code><?php echo esc_html($site_uuid); ?></code></p>
                <p><strong>Last Heartbeat Received:</strong>
                    <?php
                    // Use server's last heartbeat from API if available (more accurate)
                    if ($status && isset($status['last_heartbeat']) && $status['last_heartbeat']) {
                        echo esc_html(gmdate('Y-m-d H:i:s', strtotime($status['last_heartbeat']))) . ' UTC';
                    } elseif ($last_heartbeat) {
                        echo esc_html(gmdate('Y-m-d H:i:s', $last_heartbeat)) . ' UTC';
                    } else {
                        echo 'Never';
                    }
                    ?>
                </p>
                <p><strong>Next Check:</strong> <?php echo wp_next_scheduled('sentwatch_send_heartbeat') ? esc_html(gmdate('Y-m-d H:i:s', wp_next_scheduled('sentwatch_send_heartbeat'))) . ' UTC' : 'Not scheduled'; ?></p>
                
                <?php if (isset($status['daily_limit'])): ?>
                    <p><strong>Daily Usage:</strong> <?php echo intval($status['daily_usage']); ?> / <?php echo intval($status['daily_limit']) > 0 ? intval($status['daily_limit']) : '∞'; ?></p>
                <?php endif; ?>

                <?php if (isset($status['history']) && is_array($status['history'])): ?>
                    <div style="margin-top: 20px;">
                        <?php
                        // Calculate actual days shown based on history
                        $totalTicks = count($status['history']);
                        $intervalHours = isset($status['heartbeat_interval_hours']) ? intval($status['heartbeat_interval_hours']) : 24;
                        if ($intervalHours < 1) $intervalHours = 1;
                        $totalDays = round(($totalTicks * $intervalHours) / 24);
                        ?>
                        <strong>Uptime History (Last <?php echo esc_html($totalDays); ?> Days):</strong>
                        <div class="uptime-bar" style="display: flex; gap: 2px; height: 24px; margin-top: 5px;">
                            <?php foreach ($status['history'] as $tick): ?>
                                <?php
                                $color = '#ccc'; // Default gray
                                if ($tick['status'] == 'green') $color = '#22c55e';
                                elseif ($tick['status'] == 'red') $color = '#ef4444';
                                elseif ($tick['status'] == 'green-warning') $color = '#84cc16'; // Lime/Yellow-ish
                                elseif ($tick['status'] == 'light-gray') $color = '#e5e7eb';

                                // Use actual heartbeat timestamp when available, otherwise fall back to window end
                                if (!empty($tick['last_heartbeat_at'])) {
                                    $title = gmdate('d/m H:i', strtotime($tick['last_heartbeat_at'])) . ' UTC';
                                } elseif (!empty($tick['last_alert_at'])) {
                                    $title = gmdate('d/m H:i', strtotime($tick['last_alert_at'])) . ' UTC';
                                } else {
                                    $title = gmdate('d/m H:i', strtotime($tick['end'])) . ' UTC';
                                }

                                if ($tick['status'] == 'green') $title .= ' - OK';
                                elseif ($tick['status'] == 'red') $title .= ' - DOWN';
                                elseif ($tick['status'] == 'green-warning') $title .= ' - OK (Issues)';
                                elseif ($tick['status'] == 'light-gray') $title = 'No Data';
                                ?>
                                <div style="flex: 1; background-color: <?php echo esc_attr($color); ?>; border-radius: 2px;" title="<?php echo esc_attr($title); ?>"></div>
                            <?php endforeach; ?>
                        </div>
                        <div style="display: flex; justify-content: space-between; font-size: 11px; color: #666; margin-top: 2px;">
                            <span><?php echo esc_html($totalDays); ?> days ago</span>
                            <span>Now</span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <hr>

            <h3>Test Email Delivery</h3>
            <p>Manually trigger a test email to SentWatch to verify that your WordPress can send emails correctly.</p>
            
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                <input type="hidden" name="action" value="sentwatch_test">
                <?php wp_nonce_field('sentwatch_test_action', 'sentwatch_nonce'); ?>
                <button type="submit" class="button button-secondary">Test Email Now</button>
            </form>
        </div>
    <?php endif; ?>
</div>
