<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action('wp_footer', 'senthor_display_badge');

add_action('wp_enqueue_scripts', 'senthor_enqueue_styles');
function senthor_enqueue_styles() {
    if (is_admin()) return;
    if (!get_option('senthor_show_badge', true)) return;

    wp_enqueue_style(
            'senthor-badge-style',
            plugin_dir_url(__FILE__) . '/styles/badge.css',
            array(),
            '1.0'
    );
}

function senthor_display_badge() {
    // Only show on the front-end and if enabled
    if (is_admin()) return; 
    if (!get_option('senthor_show_badge', true)) return;

    $base_url = 'https://www.senthor.io';
    $utm_source = wp_parse_url(home_url(), PHP_URL_HOST);
    $utm_medium = 'wordpress-plugin';
    $link = add_query_arg(
            array(
                    'utm_source' => $utm_source,
                    'utm_medium' => $utm_medium,
            ),
            $base_url
    );
    ?>
    <a href="<?php echo esc_url($link); ?>" target="_blank" class="senthor-badge-wrapper">
        <span class="senthor-badge-text">Protected by Senthor</span>
        <div class="senthor-badge" title="Protected by Senthor">
            <!-- Shield icon SVG -->
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="#fff">
                <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z"/>
            </svg>
        </div>
    </a>
    <?php
}
?>